/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.format;

import io.github.miniplaceholders.api.MiniPlaceholders;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public sealed interface Formatter {
    public Component globalFormat(String var1);

    public Component globalWithExtraResolver(String var1, TagResolver var2);

    public Component audienceFormat(String var1, Audience var2);

    public Component audienceWithExtraResolver(String var1, Audience var2, TagResolver var3);

    public static Formatter basic() {
        return new Basic();
    }

    public static Formatter miniPlaceholders() {
        return new MiniPlaceholdersFormatter();
    }

    public static final class Basic
    implements Formatter {
        @Override
        public Component globalFormat(String string) {
            return MiniMessage.miniMessage().deserialize((Object)string);
        }

        @Override
        public Component globalWithExtraResolver(String string, TagResolver resolver) {
            return MiniMessage.miniMessage().deserialize(string, resolver);
        }

        @Override
        public Component audienceFormat(String string, Audience audience) {
            return MiniMessage.miniMessage().deserialize(string, (Pointered)audience);
        }

        @Override
        public Component audienceWithExtraResolver(String string, Audience audience, TagResolver resolver) {
            return MiniMessage.miniMessage().deserialize(string, (Pointered)audience, resolver);
        }
    }

    public static final class MiniPlaceholdersFormatter
    implements Formatter {
        @Override
        public Component globalFormat(String string) {
            return MiniMessage.miniMessage().deserialize(string, MiniPlaceholders.globalPlaceholders());
        }

        @Override
        public Component globalWithExtraResolver(String string, TagResolver resolver) {
            return MiniMessage.miniMessage().deserialize(string, new TagResolver[]{MiniPlaceholders.globalPlaceholders(), resolver});
        }

        @Override
        public Component audienceFormat(String string, Audience audience) {
            return MiniMessage.miniMessage().deserialize(string, (Pointered)audience, MiniPlaceholders.audienceGlobalPlaceholders());
        }

        @Override
        public Component audienceWithExtraResolver(String string, Audience audience, TagResolver resolver) {
            return MiniMessage.miniMessage().deserialize(string, (Pointered)audience, new TagResolver[]{MiniPlaceholders.audienceGlobalPlaceholders(), resolver});
        }
    }
}

