/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.paper.adapter;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.TargetSuggestionType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Server;
import org.bukkit.World;

public record WorldSuggestionType(Server server) implements TargetSuggestionType
{
    @Override
    public String targetPrefix() {
        return "world:";
    }

    @Override
    public boolean canSuggest(String lowerCasedArgument) {
        return lowerCasedArgument.indexOf(34) == 0 ? lowerCasedArgument.startsWith(this.targetPrefix(), 1) : lowerCasedArgument.startsWith(this.targetPrefix());
    }

    @Override
    public void suggestSelf(SuggestionsBuilder builder) {
        builder.suggest("world").suggest("\"world:");
    }

    @Override
    public CompletableFuture<Suggestions> provideSuggestions(String remaining, SuggestionsBuilder builder) {
        if (remaining.isBlank() || remaining.indexOf(58) == -1) {
            return builder.suggest("\"world:").suggest("world").buildFuture();
        }
        return this.provideListSuggestions(remaining, builder, this::worldNames);
    }

    private List<String> worldNames() {
        ArrayList<String> worldNames = new ArrayList<String>();
        for (World world : this.server.getWorlds()) {
            worldNames.add(world.getName());
        }
        return worldNames;
    }
}

