/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.util;

import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;

public class ParticleArc {
    private final class_243 startPos;
    private final class_243 endPos;
    private final class_243 midPos;
    private final int numSteps;
    private int currentStep;
    private final int stepsPerTick;

    public ParticleArc(class_243 startPos, class_243 endPos, int duration) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.midPos = startPos.method_1019(endPos).method_1021(0.5).method_1031(0.0, 5.0, 0.0);
        this.numSteps = 50;
        this.currentStep = 0;
        this.stepsPerTick = Math.max(1, this.numSteps / duration);
    }

    public boolean isFinished() {
        return this.currentStep >= this.numSteps;
    }

    public void tick(class_1937 level) {
        int i = 0;
        while (i < this.stepsPerTick && this.currentStep < this.numSteps) {
            double t = (double)this.currentStep / (double)this.numSteps;
            class_243 point = this.quadraticBezier(this.startPos, this.midPos, this.endPos, t);
            level.method_8406((class_2394)class_2398.field_23114, point.field_1352, point.field_1351, point.field_1350, 0.0, 0.0, 0.0);
            ++i;
            ++this.currentStep;
        }
    }

    private class_243 quadraticBezier(class_243 p0, class_243 p1, class_243 p2, double t) {
        double oneMinusT = 1.0 - t;
        return p0.method_1021(oneMinusT * oneMinusT).method_1019(p1.method_1021(2.0 * oneMinusT * t)).method_1019(p2.method_1021(t * t));
    }
}

