/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.highspeed;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import net.pcal.highspeed.HighspeedConfig;

class HighspeedConfigParser {
    HighspeedConfigParser() {
    }

    static HighspeedConfig parse(InputStream in) throws IOException {
        ImmutableMap perBlockConfigs;
        String rawJson = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        class TypoCatchingJsonReader
        extends JsonReader {
            public TypoCatchingJsonReader(StringReader in) {
                super((Reader)in);
                super.setLenient(true);
            }

            public void skipValue() {
                throw new RuntimeException("Unexpected configuration names at: " + this.getPath());
            }
        }
        HighspeedConfigGson configGson = (HighspeedConfigGson)new Gson().fromJson((JsonReader)new TypoCatchingJsonReader(new StringReader(rawJson)), TypeToken.get(HighspeedConfigGson.class));
        HighspeedConfig.PerBlockConfig defaultConfig = configGson.defaults != null ? HighspeedConfigParser.createPerBlockConfig(configGson.defaults) : (configGson.defaultSpeedLimit != null ? new HighspeedConfig.PerBlockConfig(configGson.defaultSpeedLimit, null, null, null, null, null, null, null, null) : null);
        if (configGson.blocks != null) {
            ImmutableMap.Builder pbcs = ImmutableMap.builder();
            configGson.blocks.forEach(bcg -> {
                Collection<String> blockIds;
                if (bcg.blockIds != null) {
                    blockIds = bcg.blockIds;
                } else if (bcg.blockId != null) {
                    blockIds = Set.of(bcg.blockId);
                } else {
                    throw new RuntimeException("blockIds must be set in 'blocks' configurations");
                }
                for (String blockId : blockIds) {
                    pbcs.put((Object)class_2960.method_60654((String)Objects.requireNonNull(blockId, "blockIds must not be null")), (Object)HighspeedConfigParser.mergeConfigs(defaultConfig, HighspeedConfigParser.createPerBlockConfig(bcg)));
                }
            });
            perBlockConfigs = pbcs.build();
        } else {
            perBlockConfigs = null;
        }
        return new HighspeedConfig(defaultConfig, (Map<class_2960, HighspeedConfig.PerBlockConfig>)perBlockConfigs, Objects.requireNonNullElse(configGson.isSpeedometerEnabled, true), Objects.requireNonNullElse(configGson.isTrueSpeedometerEnabled, false), Objects.requireNonNullElse(configGson.isIceBoatsEnabled, false), Objects.requireNonNullElse(configGson.isNewMinecartPhysicsForceEnabled, false));
    }

    private static HighspeedConfig.PerBlockConfig createPerBlockConfig(PerBlockConfigGson blockGson) {
        return new HighspeedConfig.PerBlockConfig(blockGson.oldMaxSpeed, blockGson.maxSpeed, blockGson.boostFactor, blockGson.boostSlowFactor, blockGson.boostSlowThreshold, blockGson.haltThreshold, blockGson.haltFactor, blockGson.slowdownFactorOccupied, blockGson.slowdownFactorEmpty);
    }

    private static HighspeedConfig.PerBlockConfig mergeConfigs(HighspeedConfig.PerBlockConfig base, HighspeedConfig.PerBlockConfig overrides) {
        if (base == null) {
            return overrides;
        }
        return new HighspeedConfig.PerBlockConfig(HighspeedConfigParser.elvis(overrides.oldMaxSpeed(), base.oldMaxSpeed()), HighspeedConfigParser.elvis(overrides.maxSpeed(), base.maxSpeed()), HighspeedConfigParser.elvis(overrides.boostFactor(), base.boostFactor()), HighspeedConfigParser.elvis(overrides.boostSlowFactor(), base.boostSlowFactor()), HighspeedConfigParser.elvis(overrides.boostSlowThreshold(), base.boostSlowThreshold()), HighspeedConfigParser.elvis(overrides.haltThreshold(), base.haltThreshold()), HighspeedConfigParser.elvis(overrides.haltFactor(), base.haltFactor()), HighspeedConfigParser.elvis(overrides.slowdownFactorOccupied(), base.slowdownFactorOccupied()), HighspeedConfigParser.elvis(overrides.slowdownFactorEmpty(), base.slowdownFactorEmpty()));
    }

    private static <T> T elvis(T first, T second) {
        return first != null ? first : second;
    }

    public static class HighspeedConfigGson {
        PerBlockConfigGson defaults;
        List<PerBlockConfigGson> blocks;
        Boolean isSpeedometerEnabled;
        Boolean isTrueSpeedometerEnabled;
        Boolean isIceBoatsEnabled;
        Boolean isNewMinecartPhysicsForceEnabled;
        @Deprecated
        Integer defaultSpeedLimit;
    }

    public static class PerBlockConfigGson {
        List<String> blockIds;
        @SerializedName(value="oldMaxSpeed", alternate={"cartSpeed", "speedLimit"})
        Integer oldMaxSpeed;
        Integer maxSpeed;
        Double boostFactor;
        Double boostSlowFactor;
        Double boostSlowThreshold;
        Double haltThreshold;
        Double haltFactor;
        Double slowdownFactorOccupied;
        Double slowdownFactorEmpty;
        @Deprecated
        String blockId;
    }
}

