/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.highspeed;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1688;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9879;
import net.minecraft.class_9883;
import net.pcal.highspeed.HighspeedClientService;
import net.pcal.highspeed.HighspeedConfig;
import net.pcal.highspeed.HighspeedConfigParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HighspeedService
implements ModInitializer {
    private static HighspeedService INSTANCE = null;
    private HighspeedConfig config;
    private HighspeedClientService clientService;
    private final Logger logger = LogManager.getLogger((String)"HighspeedRail");
    private static final String CONFIG_RESOURCE_NAME = "net/pcal/highspeed/default-config.json5";
    private static final String CONFIG_FILENAME = "highspeed-rail.json5";
    private static final Path CONFIG_FILE_PATH = Paths.get("config", "highspeed-rail.json5");

    public static HighspeedService getInstance() {
        return Objects.requireNonNull(INSTANCE);
    }

    public void onInitialize() {
        InputStream in;
        if (!CONFIG_FILE_PATH.toFile().exists()) {
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(CONFIG_RESOURCE_NAME);
                try {
                    if (in == null) {
                        throw new IllegalStateException("Unable to load net/pcal/highspeed/default-config.json5");
                    }
                    Files.createDirectories(CONFIG_FILE_PATH, new FileAttribute[0]);
                    Files.copy(in, CONFIG_FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            in = new FileInputStream(CONFIG_FILE_PATH.toFile());
            try {
                this.config = HighspeedConfigParser.parse(in);
                this.logger.info("Configuration loaded from " + String.valueOf(CONFIG_FILE_PATH.toAbsolutePath()));
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.config.isNewMinecartPhysicsForceEnabled()) {
            this.logger.warn("Experimental minecart movement is force-enabled.  This may cause unexpected behavior.");
        }
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public Integer getOldMaxSpeed(class_9883 omb, class_1688 minecart, class_2960 blockId) {
        HighspeedConfig.PerBlockConfig pbc = this.getPerBlockConfig(minecart);
        return pbc == null ? null : pbc.oldMaxSpeed();
    }

    public boolean isNewMinecartPhysicsForceEnabled() {
        return this.config.isNewMinecartPhysicsForceEnabled();
    }

    public Double getMaxSpeed(class_9879 nmb, class_1688 minecart) {
        HighspeedConfig.PerBlockConfig pbc = this.getPerBlockConfig(minecart);
        if (pbc == null) {
            return null;
        }
        return (double)Objects.requireNonNullElse(pbc.maxSpeed(), 20).intValue() * (minecart.method_5799() ? 0.5 : 1.0) / 20.0;
    }

    public Double getSlowdownFactor(class_9879 nmb, class_1688 minecart) {
        HighspeedConfig.PerBlockConfig pbc = this.getPerBlockConfig(minecart);
        if (pbc == null) {
            return null;
        }
        return minecart.method_5782() ? Objects.requireNonNullElse(pbc.slowdownFactorOccupied(), 0.997) : Objects.requireNonNullElse(pbc.slowdownFactorEmpty(), 0.975);
    }

    public double calculateBoostSlowThreshold(double defaultValue, class_1688 minecart, class_2338 blockPos) {
        HighspeedConfig.PerBlockConfig pbc = this.getPerBlockConfig(minecart, blockPos);
        if (pbc == null) {
            return defaultValue;
        }
        return Objects.requireNonNullElse(pbc.boostSlowThreshold(), defaultValue);
    }

    public double calculateBoostFactor(double defaultValue, class_1688 minecart, class_2338 blockPos) {
        HighspeedConfig.PerBlockConfig pbc = this.getPerBlockConfig(minecart, blockPos);
        if (pbc == null) {
            return defaultValue;
        }
        return Objects.requireNonNullElse(pbc.boostFactor(), defaultValue);
    }

    public double calculateBoostSlowFactor(double defaultValue, class_1688 minecart, class_2338 blockPos) {
        HighspeedConfig.PerBlockConfig pbc = this.getPerBlockConfig(minecart, blockPos);
        if (pbc == null) {
            return defaultValue;
        }
        return Objects.requireNonNullElse(pbc.boostSlowFactor(), defaultValue);
    }

    public class_243 calculateHaltTrackSpeed(class_9879 nmb, class_1688 minecart, class_243 vec3, class_2680 blockState) {
        HighspeedConfig.PerBlockConfig pbc = this.getPerBlockConfig(minecart);
        if (pbc == null) {
            return null;
        }
        return vec3.method_1033() < Objects.requireNonNullElse(pbc.haltThreshold(), 0.03) ? class_243.field_1353 : vec3.method_1021(Objects.requireNonNullElse(pbc.haltFactor(), 0.5).doubleValue());
    }

    public void initClientService(HighspeedClientService clientService) {
        if (this.clientService != null) {
            throw new IllegalStateException();
        }
        this.clientService = Objects.requireNonNull(clientService);
    }

    public boolean isSpeedometerEnabled() {
        return this.config.isSpeedometerEnabled();
    }

    public boolean isSpeedometerTrueSpeedEnabled() {
        return this.config.isTrueSpeedometerEnabled();
    }

    public boolean isIceBoatsEnabled() {
        return this.config.isIceBoatsEnabled();
    }

    public HighspeedClientService getClientService() {
        if (this.clientService == null) {
            throw new UnsupportedOperationException("clientService not initialized");
        }
        return this.clientService;
    }

    private HighspeedConfig.PerBlockConfig getPerBlockConfig(class_1688 minecart) {
        return this.getPerBlockConfig(minecart, minecart.method_62825());
    }

    private HighspeedConfig.PerBlockConfig getPerBlockConfig(class_1688 minecart, class_2338 minecartPos) {
        if (this.config.blockConfigs() == null) {
            return this.config.defaultBlockConfig();
        }
        class_2680 underState = minecart.method_73183().method_8320(minecartPos.method_10074());
        class_2960 underBlockId = class_7923.field_41175.method_10221((Object)underState.method_26204());
        HighspeedConfig.PerBlockConfig pbc = this.config.blockConfigs().get(underBlockId);
        return pbc != null ? pbc : this.config.defaultBlockConfig();
    }
}

