/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.highspeed.mixins;

import net.minecraft.class_1688;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import net.minecraft.class_9883;
import net.pcal.highspeed.HighspeedClientService;
import net.pcal.highspeed.HighspeedService;
import net.pcal.highspeed.mixins.MinecartBehaviorAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9883.class})
public abstract class OldMinecartBehaviorMixin {
    @Unique
    private static final double VANILLA_MAX_SPEED = 0.4;
    @Unique
    private static final double SQRT_TWO = 1.414213;
    @Unique
    private class_2338 lastPos = null;
    @Unique
    private double currentMaxSpeed = 0.4;
    @Unique
    private double lastMaxSpeed = 0.4;
    @Unique
    private class_243 lastSpeedPos = null;
    @Unique
    private long lastSpeedTime = 0L;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        this.updateSpeedometer();
        this.clampVelocity();
    }

    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", ordinal=0, target="java/lang/Math.min(DD)D"))
    public double speedClamp(double d1, double d2) {
        double maxSpeed = this.getModifiedMaxSpeed();
        return maxSpeed == 0.4 ? Math.min(d1, d2) : Math.min(maxSpeed * 1.414213, d2);
    }

    @Inject(method={"getMaxSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getMaxSpeed(CallbackInfoReturnable<Double> cir) {
        double maxSpeed = this.getModifiedMaxSpeed();
        if (maxSpeed != 0.4) {
            cir.setReturnValue((Object)maxSpeed);
        }
    }

    @Unique
    private double getModifiedMaxSpeed() {
        class_1688 minecart = ((MinecartBehaviorAccessor)((Object)this)).getMinecart();
        class_2338 currentPos = minecart.method_24515();
        if (currentPos.equals((Object)this.lastPos)) {
            return this.currentMaxSpeed;
        }
        this.lastPos = currentPos;
        class_243 v = minecart.method_18798();
        class_2338 nextPos = new class_2338(currentPos.method_10263() + class_3532.method_17822((double)v.method_10216()), currentPos.method_10264(), currentPos.method_10260() + class_3532.method_17822((double)v.method_10215()));
        class_2680 nextState = minecart.method_73183().method_8320(nextPos);
        class_2248 class_22482 = nextState.method_26204();
        if (class_22482 instanceof class_2241) {
            class_2241 rail = (class_2241)class_22482;
            class_2768 shape = (class_2768)nextState.method_11654(rail.method_9474());
            if (shape == class_2768.field_12663 || shape == class_2768.field_12672 || shape == class_2768.field_12664 || shape == class_2768.field_12671) {
                this.currentMaxSpeed = 0.4;
                return 0.4;
            }
            class_2680 underState = minecart.method_73183().method_8320(currentPos.method_10074());
            class_2960 underBlockId = class_7923.field_41175.method_10221((Object)underState.method_26204());
            Integer maxSpeed = HighspeedService.getInstance().getOldMaxSpeed((class_9883)this, minecart, underBlockId);
            if (maxSpeed != null) {
                this.currentMaxSpeed = (double)maxSpeed.intValue() / 20.0;
                return this.currentMaxSpeed;
            }
            this.currentMaxSpeed = 0.4;
            return 0.4;
        }
        this.currentMaxSpeed = 0.4;
        return 0.4;
    }

    @Unique
    private void clampVelocity() {
        if (this.getModifiedMaxSpeed() != this.lastMaxSpeed) {
            double smaller = Math.min(this.getModifiedMaxSpeed(), this.lastMaxSpeed);
            class_1688 minecart = ((MinecartBehaviorAccessor)((Object)this)).getMinecart();
            class_243 vel = minecart.method_18798();
            minecart.method_18799(new class_243(class_3532.method_15350((double)vel.field_1352, (double)(-smaller), (double)smaller), 0.0, class_3532.method_15350((double)vel.field_1350, (double)(-smaller), (double)smaller)));
        }
        this.lastMaxSpeed = this.currentMaxSpeed;
    }

    @Unique
    private void updateSpeedometer() {
        String display;
        HighspeedService service = HighspeedService.getInstance();
        if (!service.isSpeedometerEnabled()) {
            return;
        }
        class_1688 minecart = ((MinecartBehaviorAccessor)((class_9883)this)).getMinecart();
        if (!minecart.method_73183().method_8608()) {
            return;
        }
        HighspeedClientService client = service.getClientService();
        if (!client.isPlayerRiding(minecart)) {
            return;
        }
        double override = this.getModifiedMaxSpeed();
        class_243 vel = minecart.method_18798();
        class_243 nominalVelocity = new class_243(class_3532.method_15350((double)vel.field_1352, (double)(-override), (double)override), 0.0, class_3532.method_15350((double)vel.field_1350, (double)(-override), (double)override));
        Double nominalSpeed = nominalVelocity.method_37267() * 20.0;
        if (!HighspeedService.getInstance().isSpeedometerTrueSpeedEnabled()) {
            display = String.format("| %.2f bps |", nominalSpeed);
        } else {
            double trueSpeed;
            if (this.lastSpeedPos == null) {
                trueSpeed = 0.0;
                this.lastSpeedPos = client.getPlayerPos();
                this.lastSpeedTime = System.currentTimeMillis();
            } else {
                long now = System.currentTimeMillis();
                class_243 playerPos = client.getPlayerPos();
                class_243 vector = playerPos.method_1020(this.lastSpeedPos);
                trueSpeed = vector.method_37267() * 1000.0 / (double)(now - this.lastSpeedTime);
                this.lastSpeedPos = playerPos;
                this.lastSpeedTime = now;
            }
            display = String.format("| %.2f bps %.2f  |", nominalSpeed, trueSpeed);
        }
        client.sendPlayerMessage(display);
    }
}

