/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX;

import cn.jason31416.authX.authbackend.AbstractAuthenticator;
import cn.jason31416.authX.authbackend.LocalAuthenticator;
import cn.jason31416.authX.authbackend.UniauthAuthenticator;
import cn.jason31416.authX.command.AccountCommandHandler;
import cn.jason31416.authX.command.AdminCommandHandler;
import cn.jason31416.authX.handler.DatabaseHandler;
import cn.jason31416.authX.handler.EventListener;
import cn.jason31416.authX.handler.LimboHandler;
import cn.jason31416.authX.injection.PacketInjector;
import cn.jason31416.authX.injection.XLoginSessionHandler;
import cn.jason31416.authX.message.MessageLoader;
import cn.jason31416.authX.util.Config;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.Scheduler;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.chunk.Dimension;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.file.BuiltInWorldFileType;
import net.elytrium.limboapi.api.file.WorldFile;
import net.elytrium.limboapi.api.player.GameMode;
import org.slf4j.Logger;

@Plugin(id="authx", name="AuthX", version="2.1.4", authors={"Jason31416", "oneLiLi"}, dependencies={@Dependency(id="limboapi", optional=false)})
public class AuthXPlugin {
    public static AuthXPlugin instance;
    private final Logger logger;
    private final ProxyServer proxy;
    private final File dataDirectory;

    public static Scheduler getScheduler() {
        return AuthXPlugin.instance.proxy.getScheduler();
    }

    public void init() {
        if (!this.dataDirectory.exists()) {
            this.dataDirectory.mkdirs();
        }
        Config.init();
        MessageLoader.initialize();
        DatabaseHandler.init();
        LimboFactory factory = (LimboFactory)this.proxy.getPluginManager().getPlugin("limboapi").flatMap(PluginContainer::getInstance).orElseThrow();
        VirtualWorld authWorld = factory.createVirtualWorld(Dimension.valueOf((String)Config.getString("limbo-world.dimension").toUpperCase(Locale.ROOT)), Config.getDouble("limbo-world.position.x"), Config.getDouble("limbo-world.position.y"), Config.getDouble("limbo-world.position.z"), (float)Config.getDouble("limbo-world.position.yaw"), (float)Config.getDouble("limbo-world.position.pitch"));
        if (!Config.getString("limbo-world.world-loader.type").equalsIgnoreCase("VOID")) {
            WorldFile worldFile = factory.openWorldFile(BuiltInWorldFileType.valueOf((String)Config.getString("limbo-world.world-loader.type")), new File(this.dataDirectory, Config.getString("limbo-world.world-loader.file-name")).toPath());
            worldFile.toWorld(factory, authWorld, Config.getInt("limbo-world.world-loader.offset-x"), Config.getInt("limbo-world.world-loader.offset-y"), Config.getInt("limbo-world.world-loader.offset-z"));
        }
        if (LimboHandler.limboWorld != null) {
            LimboHandler.limboWorld.dispose();
        }
        LimboHandler.limboWorld = factory.createLimbo(authWorld).setName("AuthXLimbo").setGameMode(GameMode.valueOf((String)Config.getString("limbo-world.gamemode").toUpperCase(Locale.ROOT)));
        AbstractAuthenticator.instance = switch (Config.getString("authentication.password.method").toLowerCase(Locale.ROOT)) {
            case "uniauth" -> new UniauthAuthenticator();
            case "sqlite" -> new LocalAuthenticator();
            default -> throw new IllegalArgumentException("Invalid API source: " + Config.getString("authentication.password.uniauth"));
        };
        AbstractAuthenticator.getInstance().initialize();
    }

    @Inject
    public AuthXPlugin(@Nonnull ProxyServer proxy, @Nonnull Logger logger, @Nonnull @DataDirectory Path dataDirectory) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataDirectory = dataDirectory.toFile();
        instance = this;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.init();
        this.proxy.getEventManager().register((Object)instance, (Object)new EventListener());
        this.proxy.getCommandManager().register(this.proxy.getCommandManager().metaBuilder("authx").plugin((Object)this).build(), (Command)AdminCommandHandler.INSTANCE);
        this.proxy.getCommandManager().register(this.proxy.getCommandManager().metaBuilder("account").plugin((Object)this).build(), (Command)AccountCommandHandler.INSTANCE);
        AuthXPlugin.getScheduler().buildTask((Object)this, () -> {
            for (UUID uuid : new HashSet<UUID>(EventListener.loginPremiumFailedCache.keySet())) {
                if (EventListener.loginPremiumFailedCache.get(uuid) >= System.currentTimeMillis()) continue;
                EventListener.loginPremiumFailedCache.remove(uuid);
            }
        }).repeat(1L, TimeUnit.HOURS).schedule();
        try {
            XLoginSessionHandler.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize login session handler", e);
        }
        PacketInjector.inject();
        this.logger.info("AuthX has been enabled!");
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void warning(String message) {
        this.logger.warn(message);
    }

    @Generated
    public static AuthXPlugin getInstance() {
        return instance;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public ProxyServer getProxy() {
        return this.proxy;
    }

    @Generated
    public File getDataDirectory() {
        return this.dataDirectory;
    }
}

