/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.authbackend;

import at.favre.lib.crypto.bcrypt.BCrypt;
import cn.jason31416.authX.authbackend.AbstractAuthenticator;
import cn.jason31416.authX.handler.DatabaseHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LocalAuthenticator
extends AbstractAuthenticator {
    @Override
    public void initialize() {
        try (Connection conn = DatabaseHandler.getConnection();){
            conn.prepareStatement("CREATE TABLE IF NOT EXISTS users (username VARCHAR(255) PRIMARY KEY, password VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, format VARCHAR(255), register_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP)").execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AbstractAuthenticator.UserStatus fetchStatus(String username) {
        try (Connection conn = DatabaseHandler.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM users WHERE username =?");
            stmt.setString(1, username);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                AbstractAuthenticator.UserStatus userStatus2 = rs.getString("password") == null ? AbstractAuthenticator.UserStatus.IMPORTED : AbstractAuthenticator.UserStatus.REGISTERED;
                return userStatus2;
            }
            AbstractAuthenticator.UserStatus userStatus = AbstractAuthenticator.UserStatus.NOT_EXIST;
            return userStatus;
        }
    }

    @Override
    public AbstractAuthenticator.RequestResult requestRegister(String username, String email) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractAuthenticator.RequestResult verifyEmail(String username, String email, String password, String code) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractAuthenticator.RequestResult forceRegister(String username, String password) {
        AbstractAuthenticator.RequestResult requestResult;
        block9: {
            if (this.fetchStatus(username) != AbstractAuthenticator.UserStatus.NOT_EXIST) {
                return AbstractAuthenticator.RequestResult.USER_ALREADY_EXISTS;
            }
            Connection conn = DatabaseHandler.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement("INSERT INTO users (username, password, format, email) VALUES (?,?,?,?)");
                stmt.setString(1, username);
                stmt.setString(2, BCrypt.withDefaults().hashToString(10, password.toCharArray()));
                stmt.setString(3, "bcrypt");
                stmt.setString(4, null);
                stmt.execute();
                requestResult = AbstractAuthenticator.RequestResult.SUCCESS;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            conn.close();
        }
        return requestResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AbstractAuthenticator.RequestResult authenticate(String username, String password) {
        try (Connection conn = DatabaseHandler.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM users WHERE username =?");
            stmt.setString(1, username);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                if (rs.getString("password") == null) {
                    AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.INVALID_PASSWORD;
                    return requestResult;
                }
                if (!BCrypt.verifyer().verify((byte[])password.getBytes((Charset)StandardCharsets.UTF_8), (byte[])rs.getString((String)"password").getBytes((Charset)StandardCharsets.UTF_8)).verified) {
                    AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.INVALID_PASSWORD;
                    return requestResult;
                }
                if (rs.getString("email") == null) {
                    AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.EMAIL_NOT_LINKED;
                    return requestResult;
                }
                AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.SUCCESS;
                return requestResult;
            }
            AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.USER_DOESNT_EXIST;
            return requestResult;
        }
    }

    @Override
    public AbstractAuthenticator.RequestResult unregister(String username) {
        AbstractAuthenticator.RequestResult requestResult;
        block9: {
            if (this.fetchStatus(username) == AbstractAuthenticator.UserStatus.NOT_EXIST) {
                return AbstractAuthenticator.RequestResult.USER_DOESNT_EXIST;
            }
            Connection conn = DatabaseHandler.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement("DELETE FROM users WHERE username =?;");
                stmt.setString(1, username);
                stmt.execute();
                requestResult = AbstractAuthenticator.RequestResult.SUCCESS;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            conn.close();
        }
        return requestResult;
    }

    @Override
    public AbstractAuthenticator.RequestResult changePassword(String username, String newPassword) {
        AbstractAuthenticator.RequestResult requestResult;
        block9: {
            if (this.fetchStatus(username) == AbstractAuthenticator.UserStatus.NOT_EXIST) {
                return AbstractAuthenticator.RequestResult.USER_DOESNT_EXIST;
            }
            Connection conn = DatabaseHandler.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement("UPDATE users SET password = ? WHERE username =?");
                stmt.setString(1, BCrypt.withDefaults().hashToString(10, newPassword.toCharArray()));
                stmt.setString(2, username);
                stmt.execute();
                requestResult = AbstractAuthenticator.RequestResult.SUCCESS;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            conn.close();
        }
        return requestResult;
    }
}

