/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.authbackend;

import at.favre.lib.crypto.bcrypt.BCrypt;
import cn.jason31416.authX.AuthXPlugin;
import cn.jason31416.authX.authbackend.AbstractAuthenticator;
import cn.jason31416.authX.authbackend.UniAuthAPIClient;
import cn.jason31416.authX.handler.DatabaseHandler;
import cn.jason31416.authX.util.Config;
import cn.jason31416.authX.util.Logger;
import cn.jason31416.authX.util.MapTree;
import cn.jason31416.authX.util.RSAUtil;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UniauthAuthenticator
extends AbstractAuthenticator {
    @Override
    public AbstractAuthenticator.UserStatus fetchStatus(String username) {
        MapTree userInfo = UniAuthAPIClient.fetchUserInfo(username);
        if (!userInfo.getBoolean("profile.exists")) {
            return AbstractAuthenticator.UserStatus.NOT_EXIST;
        }
        return userInfo.getBoolean("profile.registered") ? AbstractAuthenticator.UserStatus.REGISTERED : AbstractAuthenticator.UserStatus.IMPORTED;
    }

    private void recordEncrypted(String username, String password) {
        String publicKey = UniAuthAPIClient.fetchPublicKey(false);
        String hashed = UniAuthAPIClient.hashWithFormat(publicKey, "SHA-256").substring(0, 8);
        try (Connection conn = DatabaseHandler.getConnection();){
            PreparedStatement st = conn.prepareStatement("REPLACE INTO passwordbackup (username, password, pubkeyhash) VALUES (?,?,?)");
            st.setString(1, username);
            st.setString(2, RSAUtil.encryptByPublicKey(BCrypt.withDefaults().hashToString(10, password.toCharArray()), publicKey));
            st.setString(3, hashed);
            st.executeUpdate();
        }
    }

    public static int attemptRecovery() {
        String privkey;
        String pubkey;
        File keyFile = new File(AuthXPlugin.getInstance().getDataDirectory(), "rsa_keys.json");
        if (!keyFile.exists()) {
            throw new IllegalStateException("Missing rsa_keys.json file.");
        }
        try (FileInputStream fis = new FileInputStream(keyFile);){
            MapTree item = MapTree.fromJson(new String(fis.readAllBytes()));
            pubkey = item.getString("publickey");
            privkey = item.getString("privatekey");
        }
        int cnt = 0;
        String pubkeyhash = UniAuthAPIClient.hashWithFormat(pubkey, "SHA-256").substring(0, 8);
        try (Connection conn = DatabaseHandler.getConnection();){
            conn.prepareStatement("CREATE TABLE IF NOT EXISTS users (username VARCHAR(255) PRIMARY KEY, password VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, format VARCHAR(255), register_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP)").execute();
            PreparedStatement st = conn.prepareStatement("SELECT * FROM passwordbackup");
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                String username = rs.getString("username");
                try {
                    String encryptedPassword = rs.getString("password");
                    String pubkeystored = rs.getString("pubkeyhash");
                    if (!pubkeyhash.equals(pubkeystored)) {
                        Logger.warn("Skipping " + username + " due to mismatched public key hash.");
                        continue;
                    }
                    String decryptedPassword = RSAUtil.decryptByPrivateKey(encryptedPassword, privkey);
                    PreparedStatement stmt = conn.prepareStatement("REPLACE INTO users (username, password, format, email) VALUES (?,?,?,?)");
                    stmt.setString(1, username);
                    stmt.setString(2, decryptedPassword);
                    stmt.setString(3, "bcrypt");
                    stmt.setString(4, null);
                    stmt.execute();
                    ++cnt;
                }
                catch (Exception e) {
                    Logger.error("Failed to recover password for user " + username + ": " + e.getMessage());
                }
            }
        }
        return cnt;
    }

    @Override
    public AbstractAuthenticator.RequestResult requestRegister(String username, String email) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractAuthenticator.RequestResult verifyEmail(String username, String email, String password, String code) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractAuthenticator.RequestResult forceRegister(String username, String password) {
        UniAuthAPIClient.AuthResult res = UniAuthAPIClient.registerWithoutEmail(username, password);
        if (res == UniAuthAPIClient.AuthResult.SUCCESS) {
            return AbstractAuthenticator.RequestResult.SUCCESS;
        }
        if (res == UniAuthAPIClient.AuthResult.ALREADY_REGISTERED) {
            return AbstractAuthenticator.RequestResult.USER_ALREADY_EXISTS;
        }
        return AbstractAuthenticator.RequestResult.UNKNOWN_ERROR;
    }

    @Override
    public AbstractAuthenticator.RequestResult authenticate(String username, String password) {
        AbstractAuthenticator.RequestResult ret;
        switch (UniAuthAPIClient.login(username, password)) {
            case SUCCESS: {
                AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.SUCCESS;
                break;
            }
            case INVALID_PASSWORD: {
                AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.INVALID_PASSWORD;
                break;
            }
            case NOT_REGISTERED: {
                AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.USER_DOESNT_EXIST;
                break;
            }
            case EMAIL_NOT_VERIFIED: {
                AbstractAuthenticator.RequestResult requestResult = AbstractAuthenticator.RequestResult.EMAIL_NOT_LINKED;
                break;
            }
            default: {
                AbstractAuthenticator.RequestResult requestResult = ret = AbstractAuthenticator.RequestResult.UNKNOWN_ERROR;
            }
        }
        if ((ret == AbstractAuthenticator.RequestResult.SUCCESS || ret == AbstractAuthenticator.RequestResult.EMAIL_NOT_LINKED) && Config.getConfigTree().getBoolean("authentication.password.uniauth.perform-local-backup", true)) {
            this.recordEncrypted(username, password);
        }
        return ret;
    }

    @Override
    public AbstractAuthenticator.RequestResult unregister(String username) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractAuthenticator.RequestResult changePassword(String username, String newPassword) {
        String res = UniAuthAPIClient.forceResetPassword(username, newPassword);
        if (!res.isEmpty()) {
            Logger.warn("Failed to change password for user: " + res);
        }
        return res.isEmpty() ? AbstractAuthenticator.RequestResult.SUCCESS : AbstractAuthenticator.RequestResult.UNKNOWN_ERROR;
    }

    @Override
    public AbstractAuthenticator.RequestResult changePasswordWithOld(String username, String oldPassword, String newPassword) {
        boolean res = UniAuthAPIClient.resetPassword(username, oldPassword, newPassword);
        if (res) {
            return AbstractAuthenticator.RequestResult.SUCCESS;
        }
        return AbstractAuthenticator.RequestResult.INVALID_PASSWORD;
    }
}

