/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.command;

import cn.jason31416.authX.authbackend.AbstractAuthenticator;
import cn.jason31416.authX.message.Message;
import cn.jason31416.authX.util.Config;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class AccountCommandHandler
implements SimpleCommand {
    public static final AccountCommandHandler INSTANCE = new AccountCommandHandler();

    public void execute(@NotNull SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        if (!(source instanceof Player)) {
            invocation.source().sendMessage(Message.getMessage("command.player-command").toComponent());
            return;
        }
        Player pl = (Player)source;
        String subCommand = ((String[])invocation.arguments()).length > 0 ? ((String[])invocation.arguments())[0] : "";
        String username = pl.getUsername();
        switch (subCommand) {
            case "changepass": {
                String newPassword;
                if (Config.getBoolean("command.change-password.need-old-password")) {
                    if (((String[])invocation.arguments()).length < 3) {
                        invocation.source().sendMessage(Message.getMessage("command.change-password.invalid-format-need-old-password").toComponent());
                        return;
                    }
                    if (!AbstractAuthenticator.getInstance().authenticate((String)username, (String)((String[])invocation.arguments())[1]).success) {
                        invocation.source().sendMessage(Message.getMessage("command.change-password.invalid-password").toComponent());
                        return;
                    }
                    newPassword = ((String[])invocation.arguments())[2];
                } else {
                    if (((String[])invocation.arguments()).length < 2) {
                        invocation.source().sendMessage(Message.getMessage("command.change-password.invalid-format-no-old-password").toComponent());
                        return;
                    }
                    newPassword = ((String[])invocation.arguments())[1];
                }
                if (!newPassword.matches(Config.getString("regex.password-regex"))) {
                    invocation.source().sendMessage(Message.getMessage("command.change-password.invalid-password-format").toComponent());
                    return;
                }
                if (Config.getBoolean("command.change-password.need-old-password")) {
                    AbstractAuthenticator.getInstance().changePasswordWithOld(username, ((String[])invocation.arguments())[1], newPassword);
                } else {
                    AbstractAuthenticator.getInstance().changePassword(username, newPassword);
                }
                invocation.source().sendMessage(Message.getMessage("command.change-password.success").toComponent());
                break;
            }
            default: {
                invocation.source().sendMessage(Message.getMessage("command.default").toComponent());
            }
        }
    }

    public List<String> suggest(@Nonnull SimpleCommand.Invocation invocation) {
        if (((String[])invocation.arguments()).length <= 1) {
            return List.of("changepass");
        }
        if (((String[])invocation.arguments()).length == 2) {
            return switch (((String[])invocation.arguments())[0]) {
                case "changepass" -> List.of(Config.getBoolean("command.change-password.need-old-password") ? Message.getMessage("tab-complete.change-password.old").toString() : Message.getMessage("tab-complete.change-password.new").toString());
                default -> List.of();
            };
        }
        if (((String[])invocation.arguments()).length == 3) {
            return switch (((String[])invocation.arguments())[0]) {
                case "changepass" -> {
                    if (Config.getBoolean("command.change-password.need-old-password")) {
                        yield List.of(Message.getMessage("tab-complete.change-password.new").toString());
                    }
                    yield List.of();
                }
                default -> List.of();
            };
        }
        return List.of();
    }
}

