/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.command;

import cn.jason31416.authX.AuthXPlugin;
import cn.jason31416.authX.authbackend.AbstractAuthenticator;
import cn.jason31416.authX.authbackend.UniauthAuthenticator;
import cn.jason31416.authX.handler.DatabaseHandler;
import cn.jason31416.authX.handler.EventListener;
import cn.jason31416.authX.message.Message;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.util.UuidUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class AdminCommandHandler
implements SimpleCommand {
    public static final AdminCommandHandler INSTANCE = new AdminCommandHandler();

    public void execute(@NotNull SimpleCommand.Invocation invocation) {
        String subCommand = ((String[])invocation.arguments()).length > 0 ? ((String[])invocation.arguments())[0] : "";
        if (invocation.source() instanceof Player && !invocation.source().hasPermission("authx.admin")) {
            invocation.source().sendMessage(Message.getMessage("command.no-permission").toComponent());
            return;
        }
        switch (subCommand) {
            case "changepass": {
                if (((String[])invocation.arguments()).length < 3) {
                    invocation.source().sendMessage(Message.getMessage("command.force-change-password.invalid-format").toComponent());
                    return;
                }
                String newPassword = ((String[])invocation.arguments())[2];
                String username = ((String[])invocation.arguments())[1];
                if (AbstractAuthenticator.getInstance().fetchStatus(username) == AbstractAuthenticator.UserStatus.NOT_EXIST) {
                    invocation.source().sendMessage(Message.getMessage("command.player-not-exists").add("player", username).toComponent());
                    return;
                }
                AbstractAuthenticator.getInstance().changePassword(username, newPassword);
                invocation.source().sendMessage(Message.getMessage("command.force-change-password.success").add("player", username).toComponent());
                break;
            }
            case "unregister": {
                if (((String[])invocation.arguments()).length < 2) {
                    invocation.source().sendMessage(Message.getMessage("command.force-unregister.invalid-format").toComponent());
                    return;
                }
                String username = ((String[])invocation.arguments())[1];
                if (AbstractAuthenticator.getInstance().fetchStatus(username) == AbstractAuthenticator.UserStatus.NOT_EXIST) {
                    invocation.source().sendMessage(Message.getMessage("command.player-not-exists").add("player", username).toComponent());
                    return;
                }
                if (AbstractAuthenticator.getInstance() instanceof UniauthAuthenticator) {
                    invocation.source().sendMessage(new Message("&cUniauth does not support unregistering users!").toComponent());
                    return;
                }
                AbstractAuthenticator.getInstance().unregister(username);
                invocation.source().sendMessage(Message.getMessage("command.change-password.success").toComponent());
                break;
            }
            case "reload": {
                AuthXPlugin.instance.init();
                invocation.source().sendMessage(Message.getMessage("command.reload.success").toComponent());
                break;
            }
            case "recover": {
                try {
                    int cnt = UniauthAuthenticator.attemptRecovery();
                    invocation.source().sendMessage(Message.getMessage("command.recover.success").add("count", cnt).toComponent());
                }
                catch (Exception e) {
                    invocation.source().sendMessage(Message.getMessage("command.recover.failed").add("reason", e.getMessage()).toComponent());
                }
                break;
            }
            case "setuuid": {
                UUID uuid;
                if (((String[])invocation.arguments()).length < 2) {
                    invocation.source().sendMessage(Message.getMessage("command.set-uuid.invalid-format").toComponent());
                    return;
                }
                String username = ((String[])invocation.arguments())[1];
                if (((String[])invocation.arguments()).length >= 3) {
                    try {
                        uuid = UUID.fromString(((String[])invocation.arguments())[2]);
                    }
                    catch (Exception e) {
                        invocation.source().sendMessage(Message.getMessage("command.set-uuid.invalid-uuid").toComponent());
                        return;
                    }
                } else {
                    uuid = UuidUtils.generateOfflinePlayerUuid((String)username);
                }
                DatabaseHandler.setUUID(username, uuid);
                invocation.source().sendMessage(Message.getMessage("command.set-uuid.success").add("player", username).add("uuid", uuid.toString()).toComponent());
                break;
            }
            case "clearcache": {
                EventListener.loginPremiumFailedCache.clear();
                invocation.source().sendMessage(new Message("&aCleared user authentication cache!").toComponent());
                break;
            }
            case "": {
                invocation.source().sendMessage(new Message("&aRunning &b&lAuthX v2 &aby Jason31416!").toComponent());
                break;
            }
            default: {
                invocation.source().sendMessage(Message.getMessage("command.default").toComponent());
            }
        }
    }

    public List<String> suggest(@Nonnull SimpleCommand.Invocation invocation) {
        if (((String[])invocation.arguments()).length <= 1) {
            return List.of("changepass", "unregister", "reload", "setuuid", "clearcache");
        }
        if (((String[])invocation.arguments()).length == 2) {
            return switch (((String[])invocation.arguments())[0]) {
                case "changepass" -> List.of(Message.getMessage("tab-complete.force-change-password.player").toString());
                case "unregister" -> List.of(Message.getMessage("command.force-change-password.new").toString());
                case "setuuid" -> List.of(Message.getMessage("tab-complete.set-uuid.player").toString());
                default -> List.of();
            };
        }
        if (((String[])invocation.arguments()).length == 3) {
            return switch (((String[])invocation.arguments())[0]) {
                case "changepass" -> List.of(Message.getMessage("command.force-change-password.new").toString());
                case "setuuid" -> List.of(Message.getMessage("tab-complete.set-uuid.uuid").toString());
                default -> List.of();
            };
        }
        return List.of();
    }
}

