/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.handler;

import cn.jason31416.authX.AuthXPlugin;
import cn.jason31416.authX.lib.hikari.HikariConfig;
import cn.jason31416.authX.lib.hikari.HikariDataSource;
import com.velocitypowered.api.util.UuidUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;

public class DatabaseHandler {
    public static HikariDataSource dataSource;

    public static Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public static void init() {
        if (dataSource != null && !dataSource.isClosed()) {
            dataSource.close();
        }
        HikariConfig otherConfig = new HikariConfig();
        otherConfig.setDriverClassName("org.sqlite.JDBC");
        otherConfig.setJdbcUrl("jdbc:sqlite:" + new File(AuthXPlugin.getInstance().getDataDirectory(), "usermeta.db").getAbsolutePath());
        dataSource = new HikariDataSource(otherConfig);
        try (Connection connection = DatabaseHandler.getConnection();){
            connection.prepareStatement("CREATE TABLE IF NOT EXISTS authmethods (username VARCHAR(255) PRIMARY KEY, verified VARCHAR(255), preferred VARCHAR(255))").execute();
            connection.prepareStatement("CREATE TABLE IF NOT EXISTS uuiddata (username VARCHAR(255) PRIMARY KEY, uuid VARCHAR(255))").execute();
            connection.prepareStatement("CREATE TABLE IF NOT EXISTS passwordbackup (username VARCHAR(255) PRIMARY KEY, password VARCHAR(255), pubkeyhash VARCHAR(10))").execute();
        }
    }

    public static void setUUID(String username, UUID uuid) {
        try (Connection connection = DatabaseHandler.getConnection();){
            PreparedStatement st = connection.prepareStatement("INSERT OR REPLACE INTO uuiddata (username, uuid) VALUES (?,?)");
            st.setString(1, username);
            st.setString(2, uuid.toString());
            st.execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UUID getUUID(String username) {
        try (Connection connection = DatabaseHandler.getConnection();){
            PreparedStatement st = connection.prepareStatement("SELECT uuid FROM uuiddata WHERE username =?");
            st.setString(1, username);
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                UUID uUID2 = UUID.fromString(rs.getString("uuid"));
                return uUID2;
            }
            UUID uUID = UuidUtils.generateOfflinePlayerUuid((String)username);
            return uUID;
        }
    }

    public static void setPreferred(String username, String method) {
        try (Connection connection = DatabaseHandler.getConnection();){
            PreparedStatement st = connection.prepareStatement("INSERT OR IGNORE INTO authmethods (username, verified, preferred) VALUES (?,?,?)");
            st.setString(1, username);
            st.setString(2, "");
            st.setString(3, method);
            st.execute();
            st = connection.prepareStatement("UPDATE authmethods SET preferred =? WHERE username =?");
            st.setString(1, method);
            st.setString(2, username);
            st.execute();
        }
    }

    public static void addAuthMethod(String username, String method) {
        try (Connection connection = DatabaseHandler.getConnection();){
            PreparedStatement st = connection.prepareStatement("UPDATE authmethods SET verified = verified || ? WHERE username =?");
            st.setString(1, "," + method);
            st.setString(2, username);
            st.execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getAuthMethods(String username) {
        try (Connection connection = DatabaseHandler.getConnection();){
            PreparedStatement st = connection.prepareStatement("SELECT verified FROM authmethods WHERE username =?");
            st.setString(1, username);
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                String verified = rs.getString("verified");
                if (verified != null && !verified.isEmpty()) {
                    List<String> list = List.of(verified.substring(1).split(","));
                    return list;
                }
                List<String> list = List.of();
                return list;
            }
            List<String> list = List.of();
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPreferredMethod(String username) {
        try (Connection connection = DatabaseHandler.getConnection();){
            PreparedStatement st = connection.prepareStatement("SELECT preferred FROM authmethods WHERE username =?");
            st.setString(1, username);
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                String string2 = rs.getString("preferred");
                return string2;
            }
            String string = null;
            return string;
        }
    }
}

