/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.handler;

import cn.jason31416.authX.AuthXPlugin;
import cn.jason31416.authX.authbackend.AbstractAuthenticator;
import cn.jason31416.authX.handler.DatabaseHandler;
import cn.jason31416.authX.handler.LoginSession;
import cn.jason31416.authX.message.Message;
import cn.jason31416.authX.util.Config;
import com.velocitypowered.api.proxy.Player;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.player.LimboPlayer;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;

public class LimboHandler
implements LimboSessionHandler {
    public static Map<String, LimboHandler> authPlayers = new HashMap<String, LimboHandler>();
    public static Limbo limboWorld = null;
    private String password;
    private String email;
    private String code;
    private LimboPlayer limboPlayer;
    private Player player;
    private long joinTime;
    private int attemptCount = Config.getInt("authentication.password.attempt-count");
    private AuthStage currentStage = AuthStage.UNKNOWN;
    private AtomicBoolean isAuthenticating = new AtomicBoolean(true);
    private final BossBar bossBar = BossBar.bossBar((Component)Component.empty(), (float)1.0f, (BossBar.Color)BossBar.Color.BLUE, (BossBar.Overlay)BossBar.Overlay.PROGRESS);

    public LimboHandler(Player player) {
        this.player = player;
    }

    private void switchStage(AuthStage stage) {
        if (stage == AuthStage.LOGIN) {
            this.player.showBossBar(this.bossBar);
        } else {
            this.player.hideBossBar(this.bossBar);
        }
        this.currentStage = stage;
        this.player.sendMessage(Message.getMessage("auth.message-hint." + this.currentStage.name().toLowerCase(Locale.ROOT)).toComponent());
    }

    public void finishLogin() {
        this.limboPlayer.disconnect();
        LoginSession session = LoginSession.getSessionMap().get(this.player.getUsername());
        if (session == null) {
            return;
        }
        if (session.getAuthMethod() != null && !session.getAuthMethod().isEmpty()) {
            DatabaseHandler.addAuthMethod(this.player.getUsername(), session.getAuthMethod());
        }
    }

    public static void spawnPlayer(@Nonnull Player player) {
        limboWorld.spawnPlayer(player, (LimboSessionHandler)new LimboHandler(player));
    }

    public void onSpawn(Limbo limbo, LimboPlayer limboPlayer) {
        this.limboPlayer = limboPlayer;
        this.limboPlayer.disableFalling();
        this.joinTime = System.currentTimeMillis();
        if (LoginSession.getSession(this.player.getUsername()).getPasswordIntroMessage() != null) {
            this.player.sendMessage(LoginSession.getSession(this.player.getUsername()).getPasswordIntroMessage().toComponent());
        }
        authPlayers.put(this.player.getGameProfile().getName(), this);
        long authTime = (long)Config.getInt("authentication.password.auth-time") * 1000L;
        float multiplier = 1000.0f / (float)authTime;
        AuthXPlugin.getScheduler().buildTask((Object)AuthXPlugin.getInstance(), () -> {
            try {
                if (AbstractAuthenticator.getInstance().fetchStatus(this.player.getUsername()) == AbstractAuthenticator.UserStatus.REGISTERED) {
                    this.switchStage(AuthStage.LOGIN);
                } else {
                    this.switchStage(AuthStage.REGISTER_PASSWORD);
                }
            }
            catch (Exception e) {
                this.player.disconnect(Message.getMessage("auth.failed-to-connect-to-backend").toComponent());
                throw e;
            }
        }).schedule();
        AuthXPlugin.getScheduler().buildTask((Object)AuthXPlugin.getInstance(), t -> {
            if (!this.isAuthenticating.get()) {
                t.cancel();
                return;
            }
            if (this.currentStage.equals((Object)AuthStage.LOGIN) || this.currentStage.equals((Object)AuthStage.REGISTER_PASSWORD) || this.currentStage.equals((Object)AuthStage.REGISTER_CONFIRM_PASSWORD)) {
                if (System.currentTimeMillis() - this.joinTime > authTime) {
                    this.player.disconnect(Message.getMessage("auth.timeout").toComponent());
                    this.isAuthenticating.set(false);
                } else {
                    float secondsLeft = (float)(authTime - (System.currentTimeMillis() - this.joinTime)) / 1000.0f;
                    this.bossBar.name(Message.getMessage("auth.auth-bar-name").add("time", (int)secondsLeft).toComponent());
                    this.bossBar.progress(Math.min(1.0f, secondsLeft * multiplier));
                }
            }
            this.player.sendActionBar(Message.getMessage("auth.message-hint." + this.currentStage.name().toLowerCase(Locale.ROOT)).toComponent());
        }).repeat(1L, TimeUnit.SECONDS).schedule();
    }

    public void onDisconnect() {
        authPlayers.remove(this.player.getGameProfile().getName());
        this.isAuthenticating.set(false);
        this.player.hideBossBar(this.bossBar);
    }

    public void onChat(String message) {
        switch (this.currentStage.ordinal()) {
            case 1: {
                if (this.attemptCount > 0) {
                    --this.attemptCount;
                    this.password = message;
                    this.player.sendMessage(Message.getMessage("auth.user-input").add("input", this.password.replaceAll(".", "*")).toComponent());
                    AuthXPlugin.getScheduler().buildTask((Object)AuthXPlugin.getInstance(), () -> {
                        AbstractAuthenticator.RequestResult result = AbstractAuthenticator.getInstance().authenticate(this.player.getUsername(), this.password);
                        if (result == AbstractAuthenticator.RequestResult.SUCCESS) {
                            this.player.sendMessage(Message.getMessage("auth.login-success").toComponent());
                            LoginSession.getSession(this.player.getUsername()).setPassword(this.password);
                            this.finishLogin();
                        } else if (result == AbstractAuthenticator.RequestResult.INVALID_PASSWORD) {
                            this.player.sendMessage(Message.getMessage("auth.invalid-password").toComponent());
                            this.switchStage(AuthStage.LOGIN);
                        } else if (result == AbstractAuthenticator.RequestResult.USER_DOESNT_EXIST) {
                            this.switchStage(AuthStage.REGISTER_PASSWORD);
                        } else if (result == AbstractAuthenticator.RequestResult.EMAIL_NOT_LINKED) {
                            this.player.sendMessage(Message.getMessage("auth.email-not-verified").toComponent());
                            LoginSession.getSession(this.player.getUsername()).setPassword(this.password);
                            this.finishLogin();
                        } else {
                            this.player.sendMessage(Message.getMessage("auth.unknown-error").toComponent());
                        }
                    }).schedule();
                    break;
                }
                this.player.disconnect(Message.getMessage("auth.max-attempts").toComponent());
                break;
            }
            case 2: {
                this.player.sendMessage(Message.getMessage("auth.user-input").add("input", message.replaceAll(".", "*")).toComponent());
                if (Pattern.matches(Config.getString("regex.password-regex"), message)) {
                    this.password = message;
                    this.switchStage(AuthStage.REGISTER_CONFIRM_PASSWORD);
                    break;
                }
                this.player.sendMessage(Message.getMessage("auth.password-doesnt-match-regex").toComponent());
                this.switchStage(AuthStage.REGISTER_PASSWORD);
                break;
            }
            case 3: {
                if (!message.equals(this.password)) {
                    this.player.sendMessage(Message.getMessage("auth.passwords-dont-match").toComponent());
                    this.switchStage(AuthStage.REGISTER_PASSWORD);
                    return;
                }
                this.player.sendMessage(Message.getMessage("auth.user-input").add("input", message.replaceAll(".", "*")).toComponent());
                AbstractAuthenticator.RequestResult ret = AbstractAuthenticator.getInstance().forceRegister(this.player.getUsername(), this.password);
                if (ret == AbstractAuthenticator.RequestResult.SUCCESS) {
                    this.player.sendMessage(Message.getMessage("auth.register-success").toComponent());
                    this.finishLogin();
                    break;
                }
                if (ret == AbstractAuthenticator.RequestResult.USER_ALREADY_EXISTS) {
                    this.player.sendMessage(Message.getMessage("auth.user-already-exists").toComponent());
                    break;
                }
                this.player.sendMessage(Message.getMessage("auth.unknown-error").toComponent());
            }
        }
    }

    public static enum AuthStage {
        UNKNOWN,
        LOGIN,
        REGISTER_PASSWORD,
        REGISTER_CONFIRM_PASSWORD;

    }
}

