/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.handler;

import cn.jason31416.authX.message.Message;
import cn.jason31416.authX.util.Logger;
import com.velocitypowered.api.util.UuidUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class LoginSession {
    private static Map<String, LoginSession> sessionMap = new HashMap<String, LoginSession>();
    private String username;
    private UUID uuid;
    private boolean enforcePrimaryMethod = false;
    private boolean verifyPassword = true;
    private String authMethod = null;
    private String password = null;
    private Message passwordIntroMessage = null;

    public LoginSession(String username, UUID uuid) {
        this.username = username;
        this.uuid = uuid;
    }

    public static LoginSession getSession(String username) {
        if (!sessionMap.containsKey(username)) {
            Logger.error("Unknown session found for username: " + username + "! Things might break.");
            return new LoginSession(username, UuidUtils.generateOfflinePlayerUuid((String)username));
        }
        return sessionMap.get(username);
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public boolean isEnforcePrimaryMethod() {
        return this.enforcePrimaryMethod;
    }

    @Generated
    public boolean isVerifyPassword() {
        return this.verifyPassword;
    }

    @Generated
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Message getPasswordIntroMessage() {
        return this.passwordIntroMessage;
    }

    @Generated
    public static Map<String, LoginSession> getSessionMap() {
        return sessionMap;
    }

    @Generated
    public void setEnforcePrimaryMethod(boolean enforcePrimaryMethod) {
        this.enforcePrimaryMethod = enforcePrimaryMethod;
    }

    @Generated
    public void setVerifyPassword(boolean verifyPassword) {
        this.verifyPassword = verifyPassword;
    }

    @Generated
    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setPasswordIntroMessage(Message passwordIntroMessage) {
        this.passwordIntroMessage = passwordIntroMessage;
    }
}

