/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.handler;

import cn.jason31416.authX.handler.DatabaseHandler;
import cn.jason31416.authX.handler.LoginSession;
import cn.jason31416.authX.message.Message;
import cn.jason31416.authX.util.Config;
import cn.jason31416.authX.util.Logger;
import cn.jason31416.authX.util.MapTree;
import cn.jason31416.authX.wrapper.PlayerProfile;
import com.google.gson.Gson;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class YggdrasilAuthenticator {
    public static CompletableFuture<Boolean> checkExists(String username, UUID uuid, String url) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        CompletableFuture<HttpResponse<String>> res = HttpClient.newHttpClient().sendAsync(HttpRequest.newBuilder().uri(URI.create(url + "session/minecraft/profile/" + uuid.toString().replace("-", ""))).GET().build(), HttpResponse.BodyHandlers.ofString());
        res.thenAccept(response -> {
            if (response.statusCode() == 200) {
                PlayerProfile ret = (PlayerProfile)new Gson().fromJson((String)response.body(), PlayerProfile.class);
                future.complete(username.equals(ret.name));
            } else {
                future.complete(false);
            }
        });
        return future;
    }

    public static boolean checkAllExists(String username, UUID uuid) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (String string : Config.getSection("authentication.yggdrasil.auth-servers").getKeys()) {
            String url = Config.getString("authentication.yggdrasil.auth-servers." + string);
            futures.add(YggdrasilAuthenticator.checkExists(username, uuid, url));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).completeOnTimeout(null, 10L, TimeUnit.SECONDS).join();
        for (CompletableFuture completableFuture : futures) {
            if (!((Boolean)completableFuture.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static CompletableFuture<PlayerProfile> authenticateVia(String username, String authMethod, String url) {
        CompletableFuture<PlayerProfile> future = new CompletableFuture<PlayerProfile>();
        CompletableFuture<HttpResponse<String>> res = HttpClient.newHttpClient().sendAsync(HttpRequest.newBuilder().uri(URI.create(url)).GET().build(), HttpResponse.BodyHandlers.ofString());
        res.thenAccept(response -> {
            if (response.statusCode() == 200) {
                PlayerProfile ret = (PlayerProfile)new Gson().fromJson((String)response.body(), PlayerProfile.class);
                ret.authentication = authMethod;
                LoginSession session = LoginSession.getSession(username);
                DatabaseHandler.setPreferred(username, authMethod);
                if (!DatabaseHandler.getAuthMethods(username).contains(authMethod)) {
                    session.setVerifyPassword(true);
                    session.setAuthMethod(authMethod);
                    session.setPasswordIntroMessage(Message.getMessage("auth.yggdrasil-new-need-verification").add("auth_method", authMethod));
                }
                future.complete(ret);
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public static PlayerProfile authenticate(String username, String serverID, String ip) {
        MapTree authServers = Config.getSection("authentication.yggdrasil.auth-servers");
        try {
            LoginSession session;
            String preferredMethod = DatabaseHandler.getPreferredMethod(username);
            if (preferredMethod != null && !preferredMethod.isEmpty() && authServers.contains(preferredMethod)) {
                CompletableFuture<PlayerProfile> res;
                String url = String.valueOf(authServers.get(preferredMethod)) + "session/minecraft/hasJoined?username=" + username + "&serverId=" + serverID;
                if (Config.getBoolean("authentication.yggdrasil.verify-ip")) {
                    url = url + "&ip=" + ip;
                }
                if ((res = YggdrasilAuthenticator.authenticateVia(username, preferredMethod, url)).get() != null) {
                    return res.get();
                }
            }
            if (!(session = LoginSession.getSessionMap().get(username)).isEnforcePrimaryMethod()) {
                ArrayList<CompletableFuture<PlayerProfile>> futures = new ArrayList<CompletableFuture<PlayerProfile>>();
                for (String string : authServers.getKeys()) {
                    if (string.equals(preferredMethod)) continue;
                    String url1 = String.valueOf(authServers.get(string)) + "session/minecraft/hasJoined?username=" + username + "&serverId=" + serverID;
                    if (Config.getBoolean("authentication.yggdrasil.verify-ip")) {
                        url1 = url1 + "&ip=" + ip;
                    }
                    futures.add(YggdrasilAuthenticator.authenticateVia(username, string, url1));
                }
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).completeOnTimeout(null, 10L, TimeUnit.SECONDS).join();
                for (CompletableFuture completableFuture : futures) {
                    if (!completableFuture.isDone() || completableFuture.get() == null) continue;
                    return (PlayerProfile)completableFuture.get();
                }
            }
            return null;
        }
        catch (Exception e) {
            Logger.error("Failed to authenticate " + username + ": " + e.getMessage());
            return null;
        }
    }
}

