/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.message;

import cn.jason31416.authX.AuthXPlugin;
import cn.jason31416.authX.message.Message;
import cn.jason31416.authX.util.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;

public class MessageLoader {
    public static MessageLoader instance;
    public Map<String, Object> messageConfig;

    public static void initialize() {
        File lang2;
        File langfolder = new File(AuthXPlugin.getInstance().getDataDirectory(), "lang");
        if (!langfolder.exists()) {
            langfolder.mkdir();
            List<String> supported = List.of("en-us", "zh-cn");
            supported.forEach(lang -> {
                File langfile = new File(AuthXPlugin.getInstance().getDataDirectory(), "lang/" + lang + ".yml");
                try (InputStream inputStream = AuthXPlugin.class.getClassLoader().getResourceAsStream("lang/" + lang + ".yml");
                     FileOutputStream outputStream = new FileOutputStream(langfile);){
                    ((OutputStream)outputStream).write(Objects.requireNonNull(inputStream).readAllBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot save language file: " + String.valueOf(e));
                }
            });
        }
        if (!(lang2 = new File(AuthXPlugin.getInstance().getDataDirectory(), "lang/" + Config.getString("lang") + ".yml")).exists()) {
            throw new RuntimeException("Language file doesn't exist!");
        }
        new MessageLoader(lang2);
    }

    public MessageLoader(File filePath) {
        try (FileInputStream is = new FileInputStream(filePath);){
            this.messageConfig = (Map)new Yaml().load((InputStream)is);
        }
        catch (Exception ignored) {
            throw new RuntimeException("Failed to load message config file!" + ignored.getMessage());
        }
        instance = this;
    }

    public static String get(String key, String def) {
        try {
            if (key.contains(".")) {
                String[] keys = key.split("\\.");
                Object value = MessageLoader.instance.messageConfig.get(keys[0]);
                for (int i = 1; i < keys.length; ++i) {
                    value = ((Map)value).get(keys[i]);
                }
                return value.toString();
            }
            return MessageLoader.instance.messageConfig.get(key).toString();
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Message getMessage(String key) {
        return new Message(MessageLoader.get(key, "<red>Error: message " + key + " not found, please contact admin!"));
    }

    public static Message getMessage(String key, String defaultMessage) {
        return new Message(MessageLoader.get(key, defaultMessage));
    }
}

