/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.util;

import cn.jason31416.authX.AuthXPlugin;
import cn.jason31416.authX.util.Logger;
import cn.jason31416.authX.util.MapTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.yaml.snakeyaml.Yaml;

public class Config {
    private static MapTree configTree;

    public static void init() {
        File config;
        if (!AuthXPlugin.getInstance().getDataDirectory().exists()) {
            AuthXPlugin.getInstance().getDataDirectory().mkdirs();
        }
        if (!(config = new File(AuthXPlugin.getInstance().getDataDirectory(), "config.yml")).exists()) {
            try (InputStream is = AuthXPlugin.class.getClassLoader().getResourceAsStream("config.yml");
                 FileOutputStream os = new FileOutputStream(config);){
                Objects.requireNonNull(is).transferTo(os);
            }
            catch (Exception e) {
                Logger.error("Cannot save config file!");
                throw new RuntimeException(e);
            }
        }
        try (FileInputStream inputStream = new FileInputStream(config);){
            configTree = new MapTree((Map)new Yaml().load((InputStream)inputStream));
        }
        catch (Exception e) {
            Logger.error("Failed to load config.yml: " + e.getMessage());
        }
    }

    public static Object getItem(String key) {
        return configTree.get(key);
    }

    public static MapTree getSection(String key) {
        return configTree.getSection(key);
    }

    public static int getInt(String key) {
        return configTree.getInt(key);
    }

    public static double getDouble(String key) {
        return configTree.getDouble(key);
    }

    public static String getString(String key) {
        return configTree.getString(key);
    }

    public static boolean getBoolean(String key) {
        return configTree.getBoolean(key);
    }

    public static boolean contains(String key) {
        return configTree.contains(key);
    }

    public static void reload() {
        InputStream is;
        File config;
        if (!AuthXPlugin.getInstance().getDataDirectory().exists()) {
            AuthXPlugin.getInstance().getDataDirectory().mkdirs();
        }
        if (!(config = new File(AuthXPlugin.getInstance().getDataDirectory(), "config.yml")).exists()) {
            try {
                is = AuthXPlugin.class.getClassLoader().getResourceAsStream("config.yml");
                try (FileOutputStream os = new FileOutputStream(config);){
                    Objects.requireNonNull(is).transferTo(os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            is = new FileInputStream(config);
            try {
                configTree = new MapTree((Map)new Yaml().load(is));
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public static MapTree getConfigTree() {
        return configTree;
    }
}

