/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.authX.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.yaml.snakeyaml.Yaml;

public class MapTree {
    public Map<String, Object> data;

    public MapTree(Map<String, Object> data) {
        this.data = data;
    }

    public MapTree() {
        this.data = new ConcurrentHashMap<String, Object>();
    }

    public MapTree put(String key, Object val) {
        try {
            if (key.contains(".")) {
                String[] keys = key.split("\\.");
                if (!this.data.containsKey(keys[0])) {
                    this.data.put(keys[0], new ConcurrentHashMap());
                }
                Map value = (Map)this.data.get(keys[0]);
                for (int i = 1; i < keys.length - 1; ++i) {
                    if (!this.data.containsKey(keys[0])) {
                        value.put(keys[0], new ConcurrentHashMap());
                    }
                    value = (Map)value.get(keys[0]);
                }
                value.put(keys[keys.length - 1], val);
            } else {
                this.data.put(key, val);
            }
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public Object get(String key) {
        try {
            if (key.contains(".")) {
                String[] keys = key.split("\\.");
                Object value = this.data.get(keys[0]);
                for (int i = 1; i < keys.length; ++i) {
                    value = ((Map)value).get(keys[i]);
                }
                return value;
            }
            return this.data.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public MapTree getSection(String key) {
        Object value = this.get(key);
        if (value instanceof Map) {
            return new MapTree((Map)value);
        }
        return new MapTree(new ConcurrentHashMap<String, Object>());
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public double getDouble(String key, double defaultValue) {
        Object value = this.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public List<String> getStringList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        return new ArrayList<String>();
    }

    public Set<String> getKeys() {
        return this.data.keySet();
    }

    public String toJson() {
        return new Gson().toJson(this.data);
    }

    public String toYaml() {
        return new Yaml().dump(this.data);
    }

    public static MapTree fromJson(String json) {
        return new MapTree((Map)new Gson().fromJson(json, new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static MapTree fromYaml(String yaml) {
        return new MapTree((Map)new Yaml().load(yaml));
    }
}

