/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.client.gui;

import com.adonis.createshimmer.common.registry.CSEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@OnlyIn(value=Dist.CLIENT)
public class ShimmerGui {
    private static final ResourceLocation SHIMMER_CONTAINER = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/container.png");
    private static final ResourceLocation SHIMMER_CONTAINER_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/container_blinking.png");
    private static final ResourceLocation SHIMMER_CONTAINER_HARDCORE = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/container_hardcore.png");
    private static final ResourceLocation SHIMMER_CONTAINER_HARDCORE_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/container_hardcore_blinking.png");
    private static final ResourceLocation SHIMMER_FULL = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_full.png");
    private static final ResourceLocation SHIMMER_FULL_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_full_blinking.png");
    private static final ResourceLocation SHIMMER_HALF = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_half.png");
    private static final ResourceLocation SHIMMER_HALF_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_half_blinking.png");
    private static final ResourceLocation SHIMMER_HARDCORE_FULL = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_hardcore_full.png");
    private static final ResourceLocation SHIMMER_HARDCORE_FULL_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_hardcore_full_blinking.png");
    private static final ResourceLocation SHIMMER_HARDCORE_HALF = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_hardcore_half.png");
    private static final ResourceLocation SHIMMER_HARDCORE_HALF_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"textures/gui/icons/shimmer_hardcore_half_blinking.png");
    private final RandomSource random = RandomSource.create();
    private int lastHealth = 0;
    private int displayHealth = 0;
    private long lastHealthTime = 0L;
    private long healthBlinkTime = 0L;

    @SubscribeEvent
    public void onRenderHealthLayer(RenderGuiLayerEvent.Pre event) {
        if (event.getName() != VanillaGuiLayers.PLAYER_HEALTH) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null || !player.hasEffect(CSEffects.SHIMMER_EFFECT)) {
            return;
        }
        event.setCanceled(true);
        this.renderShimmerHealth(event.getGuiGraphics(), minecraft, (Player)player);
    }

    private void renderShimmerHealth(GuiGraphics guiGraphics, Minecraft minecraft, Player player) {
        Gui gui = minecraft.gui;
        int tickCount = gui.getGuiTicks();
        int currentHealth = Mth.ceil((float)player.getHealth());
        float maxHealth = Math.max((float)player.getAttributeValue(Attributes.MAX_HEALTH), (float)Math.max(this.displayHealth, currentHealth));
        int absorptionAmount = Mth.ceil((float)player.getAbsorptionAmount());
        boolean shouldBlink = this.healthBlinkTime > (long)tickCount && (this.healthBlinkTime - (long)tickCount) / 3L % 2L == 1L;
        long currentTime = System.currentTimeMillis();
        if (currentHealth < this.lastHealth && player.invulnerableTime > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = tickCount + 20;
        } else if (currentHealth > this.lastHealth && player.invulnerableTime > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = tickCount + 10;
        }
        if (currentTime - this.lastHealthTime > 1000L) {
            this.lastHealth = currentHealth;
            this.displayHealth = currentHealth;
            this.lastHealthTime = currentTime;
        }
        this.lastHealth = currentHealth;
        this.random.setSeed((long)(tickCount * 312871));
        int left = guiGraphics.guiWidth() / 2 - 91;
        int top = guiGraphics.guiHeight() - 39;
        int totalHearts = Mth.ceil((float)((maxHealth + (float)absorptionAmount) / 2.0f));
        int heartRows = Mth.ceil((float)((float)totalHearts / 10.0f));
        int rowHeight = Math.max(10 - (heartRows - 2), 3);
        int regenOffset = -1;
        if (player.hasEffect(MobEffects.REGENERATION)) {
            regenOffset = tickCount % Mth.ceil((float)(maxHealth + 5.0f));
        }
        boolean isHardcore = player.level().getLevelData().isHardcore();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int heartIndex = totalHearts - 1; heartIndex >= 0; --heartIndex) {
            int absorbValue;
            boolean isHalf;
            boolean isAbsorption;
            int row = heartIndex / 10;
            int col = heartIndex % 10;
            int heartX = left + col * 8;
            int heartY = top - row * rowHeight;
            if (currentHealth + absorptionAmount <= 4) {
                heartY += this.random.nextInt(2);
            }
            if (heartIndex == regenOffset) {
                heartY -= 2;
            }
            ResourceLocation containerTexture = isHardcore ? (shouldBlink ? SHIMMER_CONTAINER_HARDCORE_BLINKING : SHIMMER_CONTAINER_HARDCORE) : (shouldBlink ? SHIMMER_CONTAINER_BLINKING : SHIMMER_CONTAINER);
            guiGraphics.blit(containerTexture, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9);
            int heartValue = heartIndex * 2;
            boolean bl = isAbsorption = heartIndex >= Mth.ceil((float)(maxHealth / 2.0f));
            if (shouldBlink && heartValue < this.displayHealth && !isAbsorption) {
                isHalf = heartValue + 1 == this.displayHealth;
                ResourceLocation blinkTexture = this.getHeartTexture(isHardcore, true, isHalf);
                guiGraphics.blit(blinkTexture, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9);
            }
            if (heartValue < currentHealth && !isAbsorption) {
                isHalf = heartValue + 1 == currentHealth;
                ResourceLocation heartTexture = this.getHeartTexture(isHardcore, false, isHalf);
                guiGraphics.blit(heartTexture, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9);
            }
            if (!isAbsorption || (absorbValue = heartValue - Mth.ceil((float)maxHealth)) >= absorptionAmount * 2) continue;
            boolean isHalf2 = absorbValue + 1 == absorptionAmount * 2;
            ResourceLocation absorbTexture = this.getHeartTexture(isHardcore, false, isHalf2);
            guiGraphics.blit(absorbTexture, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    private ResourceLocation getHeartTexture(boolean hardcore, boolean blinking, boolean half) {
        if (hardcore) {
            if (half) {
                return blinking ? SHIMMER_HARDCORE_HALF_BLINKING : SHIMMER_HARDCORE_HALF;
            }
            return blinking ? SHIMMER_HARDCORE_FULL_BLINKING : SHIMMER_HARDCORE_FULL;
        }
        if (half) {
            return blinking ? SHIMMER_HALF_BLINKING : SHIMMER_HALF;
        }
        return blinking ? SHIMMER_FULL_BLINKING : SHIMMER_FULL;
    }
}

