/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.item.tool;

import com.adonis.createshimmer.common.registry.CSEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public abstract class AbstractShimmerTool {
    protected static final int EFFECT_DURATION = 140;
    protected static final float SELF_EFFECT_CHANCE = 0.4f;
    protected static final float TARGET_EFFECT_CHANCE = 1.0f;
    protected static final int EFFECT_AMPLIFIER = 0;
    protected static final DustParticleOptions PURPLE_DUST = new DustParticleOptions(new Vector3f(0.6039216f, 0.3019608f, 1.0f), 1.0f);

    protected boolean applyShimmerEffectWithChance(LivingEntity entity, Level level, float chance) {
        if (level.isClientSide()) {
            return false;
        }
        if (level.random.nextFloat() >= chance) {
            return false;
        }
        entity.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 140, 0, false, true, true));
        return true;
    }

    protected boolean applyShimmerEffectToSelf(LivingEntity entity, Level level) {
        return this.applyShimmerEffectWithChance(entity, level, 0.4f);
    }

    protected boolean applyShimmerEffectToTarget(LivingEntity entity, Level level) {
        return this.applyShimmerEffectWithChance(entity, level, 1.0f);
    }

    protected void spawnBlockBreakParticles(Level level, BlockPos pos, int particleCount) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int i = 0; i < particleCount; ++i) {
            double x = (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 0.6;
            double y = (double)pos.getY() + 0.5 + (level.random.nextDouble() - 0.5) * 0.6;
            double z = (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 0.6;
            serverLevel.sendParticles((ParticleOptions)PURPLE_DUST, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void spawnAttackParticles(Level level, LivingEntity target, int particleCount, double spread) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.sendParticles((ParticleOptions)PURPLE_DUST, target.getX(), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ(), particleCount, spread, spread, spread, 0.0);
    }

    protected boolean handleBlockMine(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity, int particleCount) {
        boolean effectApplied;
        if (!level.isClientSide() && (effectApplied = this.applyShimmerEffectToSelf(entity, level))) {
            this.spawnBlockBreakParticles(level, pos, particleCount);
        }
        return true;
    }

    protected boolean handleHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker, int particleCount, double particleSpread) {
        if (!attacker.level().isClientSide()) {
            boolean attackerEffected = this.applyShimmerEffectToSelf(attacker, attacker.level());
            boolean targetEffected = this.applyShimmerEffectToTarget(target, target.level());
            if (attackerEffected || targetEffected) {
                this.spawnAttackParticles(attacker.level(), target, particleCount, particleSpread);
            }
        }
        return true;
    }

    public static class DurabilityMethods {
        public static void setDamage(ItemStack stack, int damage) {
        }

        public static boolean isDamageable(ItemStack stack) {
            return false;
        }

        public static boolean isEnchantable(ItemStack stack) {
            return true;
        }

        public static int getBarWidth(ItemStack stack) {
            return 13;
        }

        public static boolean isBarVisible(ItemStack stack) {
            return false;
        }
    }
}

