/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.data;

import com.adonis.createshimmer.common.CSCommon;
import com.adonis.createshimmer.data.CSBlockTagProvider;
import com.adonis.createshimmer.data.CSFluidTagProvider;
import com.adonis.createshimmer.data.CSItemTagProvider;
import com.adonis.createshimmer.data.CSRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.data.loading.DatagenModLoader;

@Mod(value="create_shimmer")
public class CSData {
    public CSData(IEventBus modBus) {
        if (!DatagenModLoader.isRunningDataGen()) {
            return;
        }
        CSCommon.REGISTRATE.registerBuiltinLocalization("interface");
        CSCommon.REGISTRATE.registerForeignLocalization();
        modBus.register((Object)this);
    }

    @SubscribeEvent
    public void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput output = generator.getPackOutput();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        generator.addProvider(server, (DataProvider)new CSRecipeProvider(output, lookupProvider));
        CSBlockTagProvider blockTagProvider = (CSBlockTagProvider)generator.addProvider(server, (DataProvider)new CSBlockTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new CSItemTagProvider(output, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(server, (DataProvider)new CSFluidTagProvider(output, lookupProvider, existingFileHelper));
        System.out.println("Create Shimmer: Data generators registered successfully!");
    }
}

