/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.mixin;

import com.adonis.createshimmer.util.ScepterRepairHelper;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FillingBySpout.class}, remap=false)
public class FillingBySpoutMixin {
    @Inject(method={"getRequiredAmountForItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onGetRequiredAmountForItem(Level level, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<Integer> cir) {
        if (ScepterRepairHelper.isRepairableScepter(stack) && ScepterRepairHelper.needsRepair(stack) && FillingBySpoutMixin.isShimmerFluid(availableFluid)) {
            int requiredAmount = ScepterRepairHelper.getRepairCost();
            if (ScepterRepairHelper.isDebugMode()) {
                System.out.println("Spout - Scepter repair required amount: " + requiredAmount + ", Available: " + availableFluid.getAmount() + ", Current damage: " + stack.getDamageValue());
            }
            cir.setReturnValue((Object)requiredAmount);
            return;
        }
        if (ScepterRepairHelper.isRepairableScepter(stack) && !ScepterRepairHelper.needsRepair(stack) && FillingBySpoutMixin.isShimmerFluid(availableFluid)) {
            if (ScepterRepairHelper.isDebugMode()) {
                System.out.println("Spout - Scepter is full durability, cannot repair");
            }
            cir.setReturnValue((Object)-1);
            return;
        }
    }

    private static boolean isShimmerFluid(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.isEmpty()) {
            return false;
        }
        String fluidName = fluidStack.getFluid().toString();
        boolean isShimmer = fluidName.contains("shimmer");
        if (ScepterRepairHelper.isDebugMode() && isShimmer) {
            System.out.println("Spout - Detected shimmer fluid: " + fluidName + " (" + fluidStack.getAmount() + "mB)");
        }
        return isShimmer;
    }
}

