/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.mixin;

import com.adonis.createshimmer.util.ScepterRepairHelper;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FillingRecipe.class}, remap=false)
public class FillingRecipeMixin {
    @Inject(method={"matches"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMatches(SingleRecipeInput inv, Level level, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = inv.getItem(0);
        FillingRecipe self = (FillingRecipe)this;
        if (ScepterRepairHelper.isRepairableScepter(stack)) {
            boolean isShimmerRepairRecipe = this.isShimmerRepairRecipe(self);
            if (isShimmerRepairRecipe) {
                boolean matches;
                boolean exactMatch = this.isExactScepterMatch(self, stack);
                boolean needsRepair = ScepterRepairHelper.needsRepair(stack);
                boolean bl = matches = exactMatch && needsRepair;
                if (ScepterRepairHelper.isDebugMode()) {
                    System.out.println("Scepter repair recipe match check: " + matches + " (exactMatch: " + exactMatch + ", needsRepair: " + needsRepair + ", damage: " + stack.getDamageValue() + ", item: " + String.valueOf(stack.getItem()) + ")");
                }
                cir.setReturnValue((Object)matches);
                return;
            }
            if (ScepterRepairHelper.isDebugMode()) {
                System.out.println("Preventing non-scepter recipe from matching scepter: " + String.valueOf(stack.getItem()));
            }
            cir.setReturnValue((Object)false);
            return;
        }
        if (this.isShimmerRepairRecipe(self)) {
            if (ScepterRepairHelper.isDebugMode()) {
                System.out.println("Preventing scepter repair recipe from matching non-scepter: " + String.valueOf(stack.getItem()));
            }
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"getRequiredFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetRequiredFluid(CallbackInfoReturnable<FluidIngredient> cir) {
        block5: {
            FillingRecipe self = (FillingRecipe)this;
            if (self.getFluidIngredients().isEmpty() && this.isShimmerRepairRecipeByItems(self)) {
                try {
                    Fluid shimmerFluid = this.getShimmerFluid();
                    if (shimmerFluid != null) {
                        FluidStack shimmerStack = new FluidStack(shimmerFluid, ScepterRepairHelper.getRepairCost());
                        FluidIngredient shimmerIngredient = FluidIngredient.fromFluidStack((FluidStack)shimmerStack);
                        if (ScepterRepairHelper.isDebugMode()) {
                            System.out.println("Created shimmer fluid ingredient for recipe: " + ScepterRepairHelper.getRepairCost() + "mB");
                        }
                        cir.setReturnValue((Object)shimmerIngredient);
                        return;
                    }
                }
                catch (Exception e) {
                    if (!ScepterRepairHelper.isDebugMode()) break block5;
                    System.err.println("Error creating shimmer fluid ingredient: " + e.getMessage());
                }
            }
        }
    }

    private boolean isExactScepterMatch(FillingRecipe recipe, ItemStack inputStack) {
        block6: {
            try {
                NonNullList ingredients = recipe.getIngredients();
                if (!ingredients.isEmpty()) {
                    Object[] items;
                    Ingredient ingredient = (Ingredient)ingredients.get(0);
                    for (ItemStack itemStack : items = ingredient.getItems()) {
                        if (itemStack.getItem() != inputStack.getItem()) continue;
                        if (ScepterRepairHelper.isDebugMode()) {
                            System.out.println("Exact scepter match found: " + String.valueOf(inputStack.getItem()) + " matches recipe item: " + String.valueOf(itemStack.getItem()));
                        }
                        return true;
                    }
                    if (ScepterRepairHelper.isDebugMode()) {
                        System.out.println("No exact match for " + String.valueOf(inputStack.getItem()) + " in recipe with items: " + Arrays.toString(items));
                    }
                }
            }
            catch (Exception e) {
                if (!ScepterRepairHelper.isDebugMode()) break block6;
                System.err.println("Error checking exact scepter match: " + e.getMessage());
            }
        }
        return false;
    }

    private boolean isShimmerRepairRecipe(FillingRecipe recipe) {
        block7: {
            try {
                NonNullList ingredients = recipe.getIngredients();
                if (!ingredients.isEmpty()) {
                    Ingredient ingredient = (Ingredient)ingredients.get(0);
                    ItemStack[] items = ingredient.getItems();
                    boolean hasScepter = false;
                    for (ItemStack item : items) {
                        if (!ScepterRepairHelper.isRepairableScepter(item)) continue;
                        hasScepter = true;
                        break;
                    }
                    if (hasScepter) {
                        if (!recipe.getFluidIngredients().isEmpty()) {
                            FluidIngredient fluidIngredient = (FluidIngredient)recipe.getFluidIngredients().get(0);
                            List matchingFluids = fluidIngredient.getMatchingFluidStacks();
                            for (FluidStack fluidStack : matchingFluids) {
                                if (!fluidStack.getFluid().toString().contains("shimmer")) continue;
                                return true;
                            }
                        }
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!ScepterRepairHelper.isDebugMode()) break block7;
                System.err.println("Error checking shimmer repair recipe: " + e.getMessage());
            }
        }
        return false;
    }

    private boolean isShimmerRepairRecipeByItems(FillingRecipe recipe) {
        block4: {
            try {
                NonNullList ingredients = recipe.getIngredients();
                if (!ingredients.isEmpty()) {
                    ItemStack[] items;
                    Ingredient ingredient = (Ingredient)ingredients.get(0);
                    for (ItemStack item : items = ingredient.getItems()) {
                        if (!ScepterRepairHelper.isRepairableScepter(item)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!ScepterRepairHelper.isDebugMode()) break block4;
                System.err.println("Error checking shimmer repair recipe by items: " + e.getMessage());
            }
        }
        return false;
    }

    private Fluid getShimmerFluid() {
        try {
            return (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"shimmer"));
        }
        catch (Exception e) {
            if (ScepterRepairHelper.isDebugMode()) {
                System.err.println("Error getting shimmer fluid: " + e.getMessage());
            }
            return null;
        }
    }
}

