/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.mixin;

import com.adonis.createshimmer.util.ScepterRepairHelper;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProcessingRecipe.class}, remap=false)
public class ProcessingRecipeMixin {
    @Inject(method={"getResultItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetResultItem(HolderLookup.Provider registryAccess, CallbackInfoReturnable<ItemStack> cir) {
        FillingRecipe fillingRecipe;
        ProcessingRecipe recipe = (ProcessingRecipe)this;
        if (recipe instanceof FillingRecipe && this.isShimmerRepairRecipe(fillingRecipe = (FillingRecipe)recipe) && !fillingRecipe.getRollableResults().isEmpty()) {
            ItemStack result = ((ProcessingOutput)fillingRecipe.getRollableResults().get(0)).getStack().copy();
            if (ScepterRepairHelper.isDebugMode()) {
                System.out.println("ProcessingRecipe - Returning recipe result for JEI: " + String.valueOf(result.getItem()));
            }
            cir.setReturnValue((Object)result);
            return;
        }
    }

    @Inject(method={"assemble"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(RecipeInput input, HolderLookup.Provider registryAccess, CallbackInfoReturnable<ItemStack> cir) {
        ProcessingRecipe recipe = (ProcessingRecipe)this;
        if (recipe instanceof FillingRecipe) {
            SingleRecipeInput singleInput;
            ItemStack inputStack;
            FillingRecipe fillingRecipe = (FillingRecipe)recipe;
            if (input instanceof SingleRecipeInput && ScepterRepairHelper.isRepairableScepter(inputStack = (singleInput = (SingleRecipeInput)input).getItem(0)) && ScepterRepairHelper.needsRepair(inputStack) && this.isShimmerRepairRecipe(fillingRecipe)) {
                ItemStack baseResult = !fillingRecipe.getRollableResults().isEmpty() ? ((ProcessingOutput)fillingRecipe.getRollableResults().get(0)).getStack().copy() : inputStack.copy();
                if (baseResult.getItem() != inputStack.getItem()) {
                    if (ScepterRepairHelper.isDebugMode()) {
                        System.out.println("ProcessingRecipe - Recipe result type mismatch! Input: " + String.valueOf(inputStack.getItem()) + ", Recipe result: " + String.valueOf(baseResult.getItem()));
                    }
                    baseResult = inputStack.copy();
                }
                ItemStack repairedScepter = ScepterRepairHelper.repairScepter(baseResult);
                if (ScepterRepairHelper.isDebugMode()) {
                    System.out.println("ProcessingRecipe - Assembling repaired scepter: " + String.valueOf(inputStack.getItem()) + " (" + inputStack.getDamageValue() + " -> " + repairedScepter.getDamageValue() + ")");
                }
                cir.setReturnValue((Object)repairedScepter);
                return;
            }
        }
    }

    private boolean isShimmerRepairRecipe(FillingRecipe recipe) {
        block6: {
            try {
                NonNullList ingredients;
                if (!recipe.getFluidIngredients().isEmpty()) {
                    FluidIngredient fluidIngredient = (FluidIngredient)recipe.getFluidIngredients().get(0);
                    List matchingFluids = fluidIngredient.getMatchingFluidStacks();
                    for (FluidStack fluidStack : matchingFluids) {
                        if (!fluidStack.getFluid().toString().contains("shimmer")) continue;
                        return true;
                    }
                }
                if (!(ingredients = recipe.getIngredients()).isEmpty()) {
                    ItemStack[] items;
                    Ingredient ingredient = (Ingredient)ingredients.get(0);
                    for (ItemStack item : items = ingredient.getItems()) {
                        if (!ScepterRepairHelper.isRepairableScepter(item)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!ScepterRepairHelper.isDebugMode()) break block6;
                System.err.println("Error checking shimmer repair recipe: " + e.getMessage());
            }
        }
        return false;
    }
}

