/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.util;

import com.adonis.createshimmer.config.CSConfig;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ScepterRepairHelper {
    private static final Set<String> REPAIRABLE_SCEPTERS = Set.of("twilightforest:lifedrain_scepter", "twilightforest:zombie_scepter", "twilightforest:fortification_scepter", "twilightforest:twilight_scepter");

    public static boolean isRepairableScepter(ItemStack stack) {
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            if (ScepterRepairHelper.isDebugMode() && !stack.isEmpty()) {
                System.out.println("Item is not damageable: " + String.valueOf(stack.getItem()));
            }
            return false;
        }
        if (!((Boolean)CSConfig.repair().enableScepterRepair.get()).booleanValue()) {
            if (ScepterRepairHelper.isDebugMode()) {
                System.out.println("Scepter repair is disabled in config");
            }
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        boolean isRepairable = REPAIRABLE_SCEPTERS.contains(itemId.toString());
        if (ScepterRepairHelper.isDebugMode()) {
            System.out.println("Checking item: " + String.valueOf(itemId) + ", is repairable: " + isRepairable);
        }
        return isRepairable;
    }

    public static boolean needsRepair(ItemStack stack) {
        boolean needs;
        boolean bl = needs = ScepterRepairHelper.isRepairableScepter(stack) && stack.getDamageValue() > 0;
        if (ScepterRepairHelper.isDebugMode() && ScepterRepairHelper.isRepairableScepter(stack)) {
            System.out.println("Scepter needs repair: " + needs + ", current damage: " + stack.getDamageValue() + ", max damage: " + stack.getMaxDamage());
        }
        return needs;
    }

    public static int getRepairCost() {
        int cost = (Integer)CSConfig.repair().scepterRepairCost.get();
        if (ScepterRepairHelper.isDebugMode()) {
            System.out.println("Repair cost: " + cost + "mB");
        }
        return cost;
    }

    public static int getRepairAmount() {
        int amount = (Integer)CSConfig.repair().scepterRepairAmount.get();
        if (ScepterRepairHelper.isDebugMode()) {
            System.out.println("Repair amount: " + amount + " durability points");
        }
        return amount;
    }

    public static ItemStack repairScepter(ItemStack originalScepter) {
        if (!ScepterRepairHelper.needsRepair(originalScepter)) {
            if (ScepterRepairHelper.isDebugMode()) {
                System.out.println("Scepter doesn't need repair, returning copy");
            }
            return originalScepter.copy();
        }
        ItemStack repairedScepter = originalScepter.copy();
        int currentDamage = repairedScepter.getDamageValue();
        int repairAmount = ScepterRepairHelper.getRepairAmount();
        int newDamage = Math.max(0, currentDamage - repairAmount);
        if (ScepterRepairHelper.isDebugMode()) {
            System.out.println("Repairing scepter: " + currentDamage + " -> " + newDamage + " (repaired " + repairAmount + " points)");
        }
        repairedScepter.setDamageValue(newDamage);
        return repairedScepter;
    }

    public static boolean isDebugMode() {
        try {
            return (Boolean)CSConfig.repair().debugMode.get();
        }
        catch (Exception e) {
            return false;
        }
    }
}

