/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.block;

import com.adonis.createshimmer.common.fluids.shimmer.ShimmerLiquidBlock;
import com.adonis.createshimmer.common.registry.CSFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import twilightforest.block.TorchberryPlantBlock;

public class MagicSoilBlock
extends Block {
    public static final BooleanProperty SHIMMER_ENHANCED = BooleanProperty.create((String)"shimmer_enhanced");

    public MagicSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SHIMMER_ENHANCED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHIMMER_ENHANCED});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)SHIMMER_ENHANCED) != false ? 8 : 2;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)SHIMMER_ENHANCED)).booleanValue()) {
            this.addShimmerParticles(level, pos, random);
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        boolean hasShimmerNearby = this.hasShimmerFluidNearby((Level)level, pos);
        boolean currentlyEnhanced = (Boolean)state.getValue((Property)SHIMMER_ENHANCED);
        if (hasShimmerNearby != currentlyEnhanced) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SHIMMER_ENHANCED, (Comparable)Boolean.valueOf(hasShimmerNearby)), 3);
        }
        if (random.nextInt(2) != 0) {
            return;
        }
        this.regenerateEffects(level, pos, random);
        if (hasShimmerNearby) {
            this.acceleratePlantGrowth(level, pos, random);
        }
    }

    private boolean hasShimmerFluidNearby(Level level, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = pos.offset(x, y, z);
                    try {
                        FluidState fluidState = level.getFluidState(checkPos);
                        if (!(fluidState.isEmpty() || fluidState.getType() != CSFluids.SHIMMER.get() && fluidState.getType() != CSFluids.SHIMMER.getSource())) {
                            return true;
                        }
                        BlockState blockState = level.getBlockState(checkPos);
                        if (!(blockState.getBlock() instanceof ShimmerLiquidBlock)) continue;
                        return true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    private void addShimmerParticles(Level level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        Direction direction;
        if (!(random.nextInt(3) != 0 || (direction = Direction.getRandom((RandomSource)random)) == Direction.UP || (blockstate = level.getBlockState(blockpos = pos.relative(direction))).isSolid() && blockstate.isFaceSturdy((BlockGetter)level, blockpos, direction.getOpposite()))) {
            double d0 = direction.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepX() * 0.6;
            double d1 = direction.getStepY() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepY() * 0.6;
            double d2 = direction.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.6;
            level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_OBSIDIAN_TEAR, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
        }
        if (random.nextInt(8) == 0) {
            Direction[] horizontalDirections = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.DOWN};
            Direction dir = horizontalDirections[random.nextInt(horizontalDirections.length)];
            double x = (double)pos.getX() + 0.5 + (double)dir.getStepX() * 0.6 + (random.nextDouble() - 0.5) * 0.2;
            double y = (double)pos.getY() + (dir == Direction.DOWN ? 0.1 : random.nextDouble());
            double z = (double)pos.getZ() + 0.5 + (double)dir.getStepZ() * 0.6 + (random.nextDouble() - 0.5) * 0.2;
            level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_OBSIDIAN_TEAR, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void regenerateEffects(ServerLevel level, BlockPos pos, RandomSource random) {
        this.regenerateCaveVineBerries(level, pos, random);
        this.regenerateTorchberries(level, pos, random);
    }

    private void regenerateCaveVineBerries(ServerLevel level, BlockPos pos, RandomSource random) {
        this.regenerateVineChainBelow(level, pos, random);
        this.regenerateVineChainAbove(level, pos, random);
    }

    private void regenerateVineChainBelow(ServerLevel level, BlockPos startPos, RandomSource random) {
        BlockState currentState;
        BlockPos currentPos = startPos.below();
        int maxDepth = 16;
        for (int depth = 0; depth < maxDepth && this.isCaveVineBlock(currentState = level.getBlockState(currentPos)); ++depth) {
            if (!CaveVines.hasGlowBerries((BlockState)currentState) && random.nextInt(4) == 0) {
                BlockState newState = (BlockState)currentState.setValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(true));
                level.setBlock(currentPos, newState, 2);
            }
            currentPos = currentPos.below();
        }
    }

    private void regenerateVineChainAbove(ServerLevel level, BlockPos startPos, RandomSource random) {
        BlockState currentState;
        BlockPos currentPos = startPos.above();
        int maxHeight = 16;
        for (int height = 0; height < maxHeight && this.isCaveVineBlock(currentState = level.getBlockState(currentPos)); ++height) {
            if (!CaveVines.hasGlowBerries((BlockState)currentState) && random.nextInt(4) == 0) {
                BlockState newState = (BlockState)currentState.setValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(true));
                level.setBlock(currentPos, newState, 2);
            }
            currentPos = currentPos.above();
        }
    }

    private void regenerateTorchberries(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos[] checkPositions;
        for (BlockPos checkPos : checkPositions = new BlockPos[]{pos.above(), pos.below()}) {
            BooleanProperty hasBerries;
            BlockState checkState = level.getBlockState(checkPos);
            if (!(checkState.getBlock() instanceof TorchberryPlantBlock) || !checkState.hasProperty((Property)(hasBerries = TorchberryPlantBlock.HAS_BERRIES)) || ((Boolean)checkState.getValue((Property)hasBerries)).booleanValue() || random.nextInt(4) != 0) continue;
            BlockState newState = (BlockState)checkState.setValue((Property)hasBerries, (Comparable)Boolean.valueOf(true));
            level.setBlock(checkPos, newState, 2);
        }
    }

    private void acceleratePlantGrowth(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos[] checkPositions;
        for (BlockPos checkPos : checkPositions = new BlockPos[]{pos.above(), pos.below()}) {
            BlockState checkState = level.getBlockState(checkPos);
            Block checkBlock = checkState.getBlock();
            if (checkBlock instanceof BonemealableBlock) {
                BonemealableBlock bonemealable = (BonemealableBlock)checkBlock;
                if (!this.isFlowerBlock(checkState)) {
                    this.tryBonemealGrowth(level, checkPos, checkState, bonemealable, random);
                    continue;
                }
            }
            this.handleSpecialVanillaPlants(level, checkPos, checkState, checkBlock, random);
        }
    }

    private boolean isFlowerBlock(BlockState state) {
        return state.is(BlockTags.FLOWERS) || state.is(BlockTags.SMALL_FLOWERS) || state.is(BlockTags.TALL_FLOWERS);
    }

    private void tryBonemealGrowth(ServerLevel level, BlockPos pos, BlockState state, BonemealableBlock bonemealable, RandomSource random) {
        try {
            if (bonemealable.isValidBonemealTarget((LevelReader)level, pos, state) && bonemealable.isBonemealSuccess((Level)level, random, pos, state) && random.nextInt(4) == 0) {
                bonemealable.performBonemeal(level, random, pos, state);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleSpecialVanillaPlants(ServerLevel level, BlockPos pos, BlockState state, Block block, RandomSource random) {
        if (block == Blocks.SUGAR_CANE) {
            if (random.nextInt(5) == 0) {
                this.growSugarCane(level, pos, random);
            }
            return;
        }
        if (block == Blocks.CACTUS && random.nextInt(5) == 0) {
            this.growCactus(level, pos, random);
        }
    }

    private void growSugarCane(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos growPos;
        int height = 1;
        while (level.getBlockState(pos.above(height)).is(Blocks.SUGAR_CANE)) {
            ++height;
        }
        if (height < 8 && level.isEmptyBlock(growPos = pos.above(height))) {
            level.setBlockAndUpdate(growPos, Blocks.SUGAR_CANE.defaultBlockState());
        }
    }

    private void growCactus(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos growPos;
        int height = 1;
        while (level.getBlockState(pos.above(height)).is(Blocks.CACTUS)) {
            ++height;
        }
        if (height < 8 && level.isEmptyBlock(growPos = pos.above(height))) {
            level.setBlockAndUpdate(growPos, Blocks.CACTUS.defaultBlockState());
        }
    }

    private boolean isCaveVineBlock(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.CAVE_VINES || block == Blocks.CAVE_VINES_PLANT || state.hasProperty((Property)BlockStateProperties.BERRIES) && (block.toString().contains("cave_vine") || block.getClass().getSimpleName().toLowerCase().contains("cavevine"));
    }
}

