/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.effects;

import com.adonis.createshimmer.common.item.tool.ShimmerAxeItem;
import com.adonis.createshimmer.common.item.tool.ShimmerPickaxeItem;
import com.adonis.createshimmer.common.item.tool.ShimmerShovelItem;
import com.adonis.createshimmer.common.item.tool.ShimmerSwordItem;
import com.adonis.createshimmer.common.registry.CSEffects;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class ShimmerEffect
extends MobEffect {
    public static final double ATTACK_SPEED_MODIFIER = 0.35;
    public static final double ATTACK_DAMAGE_MODIFIER = 0.0;
    public static final double DIG_SPEED_MODIFIER = 0.35;
    public static final double MOVEMENT_SPEED_MODIFIER = 0.35;
    private static final float HUNGER_EXHAUSTION_PER_TICK = 0.005f;
    private static final int HUNGER_TICK_INTERVAL = 20;
    private static final Map<LivingEntity, Boolean> NON_PLAYER_ENTITIES = new WeakHashMap<LivingEntity, Boolean>();

    public ShimmerEffect() {
        super(MobEffectCategory.NEUTRAL, 4854924);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            NON_PLAYER_ENTITIES.put(entity, true);
            this.removeAttributeModifiers(entity.getAttributes());
        }
        super.onEffectStarted(entity, amplifier);
    }

    public void addAttributeModifiers(AttributeMap attributeMap, int amplifier) {
        super.addAttributeModifiers(attributeMap, amplifier);
    }

    public void onMobRemoved(LivingEntity entity, int amplifier, Entity.RemovalReason reason) {
        NON_PLAYER_ENTITIES.remove(entity);
        super.onMobRemoved(entity, amplifier, reason);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Player player;
        if (!(entity instanceof Player) && !NON_PLAYER_ENTITIES.containsKey(entity)) {
            NON_PLAYER_ENTITIES.put(entity, true);
            this.removeAttributeModifiers(entity.getAttributes());
        }
        if (!entity.level().isClientSide() && entity instanceof Player && !(player = (Player)entity).isCreative() && !player.isSpectator()) {
            FoodData foodData = player.getFoodData();
            foodData.addExhaustion(0.099999994f);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }

    public static class ShimmerEventHandler {
        private static final float ADDITIONAL_MAGIC_DAMAGE = 8.0f;
        private static final double ADDITIONAL_DAMAGE_CHANCE = 0.4;

        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            try {
                boolean isShimmerTool;
                Player player = event.getEntity();
                if (player == null) {
                    return;
                }
                ItemStack heldItem = player.getMainHandItem();
                if (heldItem == null || heldItem.isEmpty()) {
                    return;
                }
                boolean bl = isShimmerTool = heldItem.getItem() instanceof ShimmerPickaxeItem || heldItem.getItem() instanceof ShimmerAxeItem || heldItem.getItem() instanceof ShimmerShovelItem;
                if (!isShimmerTool) {
                    return;
                }
                if (player.hasEffect(CSEffects.SHIMMER_EFFECT)) {
                    float currentSpeed = event.getNewSpeed();
                    if (currentSpeed <= 0.0f) {
                        currentSpeed = event.getOriginalSpeed();
                    }
                    if (currentSpeed <= 0.0f) {
                        currentSpeed = 1.0f;
                    }
                    float newSpeed = currentSpeed * 4.0f;
                    newSpeed = Math.max(0.1f, Math.min(newSpeed, 100.0f));
                    event.setNewSpeed(newSpeed);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @SubscribeEvent
        public static void onLivingDamagePreForShimmerTools(LivingDamageEvent.Pre event) {
            try {
                DamageSource source = event.getSource();
                if (source == null) {
                    return;
                }
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ItemStack weapon = player.getMainHandItem();
                    if (weapon == null || weapon.isEmpty()) {
                        return;
                    }
                    if (player.hasEffect(CSEffects.SHIMMER_EFFECT)) {
                        float extraDamage = 0.0f;
                        if (weapon.getItem() instanceof ShimmerSwordItem) {
                            extraDamage = 3.0f;
                        } else if (weapon.getItem() instanceof ShimmerAxeItem) {
                            extraDamage = 2.0f;
                        } else if (weapon.getItem() instanceof ShimmerPickaxeItem) {
                            extraDamage = 3.0f;
                        } else if (weapon.getItem() instanceof ShimmerShovelItem) {
                            extraDamage = 3.0f;
                        }
                        if (extraDamage > 0.0f) {
                            float originalDamage = event.getNewDamage();
                            event.setNewDamage(originalDamage + extraDamage);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @SubscribeEvent
        public static void onLivingDamagePreForSweep(LivingDamageEvent.Pre event) {
            try {
                LivingEntity attacker;
                ItemStack weapon;
                DamageSource source = event.getSource();
                LivingEntity target = event.getEntity();
                Entity entity = source.getEntity();
                if (entity instanceof LivingEntity && (weapon = (attacker = (LivingEntity)entity).getMainHandItem()).getItem() instanceof ShimmerSwordItem && !target.level().isClientSide()) {
                    ((ServerLevel)target.level()).getServer().execute(() -> {
                        if (target.isAlive() && !target.hasEffect(CSEffects.SHIMMER_EFFECT)) {
                            target.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 140, 0, false, true, true));
                        }
                    });
                    Level level = target.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, target.getX(), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ(), 3, 0.1, 0.1, 0.1, 0.02);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @SubscribeEvent
        public static void onLivingDamaged(LivingDamageEvent.Post event) {
            Player player;
            LivingEntity entity = event.getEntity();
            DamageSource source = event.getSource();
            if (source.is(DamageTypes.MAGIC)) {
                return;
            }
            if (!entity.hasEffect(CSEffects.SHIMMER_EFFECT)) {
                return;
            }
            if (entity.level().isClientSide()) {
                return;
            }
            if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
                return;
            }
            float actualDamage = event.getNewDamage();
            if (actualDamage < 0.5f) {
                return;
            }
            if (entity.level().random.nextDouble() < 0.4) {
                Level level;
                int originalInvulnerableTime = entity.invulnerableTime;
                entity.invulnerableTime = 0;
                DamageSource magicDamage = entity.damageSources().magic();
                boolean damaged = entity.hurt(magicDamage, 8.0f);
                if (!damaged) {
                    entity.invulnerableTime = originalInvulnerableTime;
                }
                if ((level = entity.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    double x = entity.getX();
                    double y = entity.getY() + (double)entity.getBbHeight() / 2.0;
                    double z = entity.getZ();
                    for (int i = 0; i < 5; ++i) {
                        double offsetX = entity.level().random.nextGaussian() * 0.2;
                        double offsetY = entity.level().random.nextGaussian() * 0.2;
                        double offsetZ = entity.level().random.nextGaussian() * 0.2;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingDamageEvent.Pre event) {
            Level level;
            LivingEntity attacker;
            DamageSource source = event.getSource();
            Entity entity = source.getEntity();
            if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).hasEffect(CSEffects.SHIMMER_EFFECT) && (level = attacker.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (event.getEntity() != null) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, event.getEntity().getX(), event.getEntity().getY() + (double)(event.getEntity().getBbHeight() / 2.0f), event.getEntity().getZ(), 3, 0.1, 0.1, 0.1, 0.02);
                }
            }
        }
    }
}

