/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.events;

import com.adonis.createshimmer.common.registry.CSEffects;
import com.adonis.createshimmer.common.registry.CSItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.init.TFSounds;
import twilightforest.network.SpawnCharmPacket;
import twilightforest.util.TFItemStackUtils;

@EventBusSubscriber(modid="create_shimmer")
public class CSCharmEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (!(event.isCanceled() || entity.level().isClientSide() || !(entity instanceof Player) || (player = (Player)entity) instanceof FakePlayer || player.isCreative() || player.isSpectator() || !CSCharmEvents.applyShimmerCharm(player))) {
            event.setCanceled(true);
        }
    }

    private static boolean applyShimmerCharm(Player player) {
        ItemStack consumedStack;
        boolean consumedCharm1;
        boolean consumedCharm2 = TFItemStackUtils.consumeInventoryItem((Player)player, (ItemLike)((ItemLike)CSItems.CHARM_OF_SHIMMER_2.get()), (CompoundTag)CSCharmEvents.getPlayerData(player), (boolean)false) || CSCharmEvents.hasCharmCurio((Item)CSItems.CHARM_OF_SHIMMER_2.get(), player);
        boolean bl = consumedCharm1 = !consumedCharm2 && (TFItemStackUtils.consumeInventoryItem((Player)player, (ItemLike)((ItemLike)CSItems.CHARM_OF_SHIMMER_1.get()), (CompoundTag)CSCharmEvents.getPlayerData(player), (boolean)false) || CSCharmEvents.hasCharmCurio((Item)CSItems.CHARM_OF_SHIMMER_1.get(), player));
        if (!consumedCharm1 && !consumedCharm2) {
            return false;
        }
        if (consumedCharm1) {
            consumedStack = new ItemStack((ItemLike)CSItems.CHARM_OF_SHIMMER_1.get());
            player.setHealth(10.0f);
            player.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 200, 0));
        } else {
            consumedStack = new ItemStack((ItemLike)CSItems.CHARM_OF_SHIMMER_2.get());
            player.setHealth(player.getMaxHealth());
            player.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 600, 0));
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SpawnCharmPacket(consumedStack, TFSounds.CHARM_LIFE.getKey()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public static CompoundTag getPlayerData(Player player) {
        if (!player.getPersistentData().contains("PlayerPersisted")) {
            player.getPersistentData().put("PlayerPersisted", (Tag)new CompoundTag());
        }
        return player.getPersistentData().getCompound("PlayerPersisted");
    }

    private static boolean hasCharmCurio(Item item, Player player) {
        return ModList.get().isLoaded("curios") && CuriosCompat.findAndConsumeCurio((Item)item, (Player)player);
    }
}

