/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.fluids.shimmer;

import com.adonis.createshimmer.common.registry.CSEffects;
import com.tterrag.registrate.builders.FluidBuilder;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import plus.dragons.createdragonsplus.common.fluids.SolidRenderFluidType;

public final class ShimmerFluidType
extends SolidRenderFluidType {
    private ShimmerFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, int tintColor, Vector3f fogColor, Supplier<Float> fogDistanceModifier) {
        super(properties, stillTexture, flowingTexture, tintColor, fogColor, fogDistanceModifier);
    }

    public static FluidBuilder.FluidTypeFactory create() {
        int tintColor = FastColor.ARGB32.opaque((int)0xFFFFFF);
        Vector3f fogColor = new Color(14589381).asVectorF();
        return (properties, stillTexture, flowingTexture) -> new ShimmerFluidType(properties, stillTexture, flowingTexture, tintColor, fogColor, ShimmerFluidType::getVisibility);
    }

    private static float getVisibility() {
        return 0.00390625f;
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean falling = entity.getDeltaMovement().y <= 0.0;
        double y = entity.getY();
        entity.moveRelative(0.02f, movementVector);
        entity.move(MoverType.SELF, entity.getDeltaMovement());
        if (entity.getFluidTypeHeight((FluidType)this) <= entity.getFluidJumpThreshold()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.5, (double)0.8f, 0.5));
            Vec3 adjustedMovement = entity.getFluidFallingAdjustedMovement(gravity, falling, entity.getDeltaMovement());
            entity.setDeltaMovement(adjustedMovement);
        } else {
            entity.setDeltaMovement(entity.getDeltaMovement().scale(0.5));
        }
        if (gravity != 0.0) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -gravity / 4.0, 0.0));
        }
        Vec3 deltaMovement = entity.getDeltaMovement();
        if (entity.horizontalCollision && entity.isFree(deltaMovement.x, deltaMovement.y + (double)0.6f - entity.getY() + y, deltaMovement.z)) {
            entity.setDeltaMovement(deltaMovement.x, (double)0.3f, deltaMovement.z);
        }
        return true;
    }

    public void setItemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        entity.setDeltaMovement(vec3.x * (double)0.95f, vec3.y + (double)(vec3.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3.z * (double)0.95f);
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return level.dimensionType().ultraWarm();
    }

    public void onVaporize(@Nullable Player player, Level level, BlockPos pos, FluidStack stack) {
        SoundEvent sound = this.getSound(player, (BlockGetter)level, pos, SoundActions.FLUID_VAPORIZE);
        level.playSound(player, pos, sound != null ? sound : SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
        AreaEffectCloud aoe = new AreaEffectCloud(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        aoe.setOwner((LivingEntity)player);
        aoe.setParticle((ParticleOptions)ParticleTypes.END_ROD);
        aoe.setRadius((float)stack.getAmount() / 500.0f);
        aoe.setDuration(stack.getAmount() / 5);
        aoe.setRadiusPerTick(-0.01f);
        aoe.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 20, 0));
        aoe.getPersistentData().putBoolean("Shimmer", true);
        level.levelEvent(2006, pos, -1);
        level.addFreshEntity((Entity)aoe);
    }
}

