/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.fluids.shimmer;

import com.adonis.createshimmer.common.registry.CSEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;

public class ShimmerLiquidBlock
extends LiquidBlock {
    public ShimmerLiquidBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.isClientSide()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.tickCount % 5 != 0) {
            return;
        }
        if (livingEntity.isDeadOrDying()) {
            return;
        }
        if (livingEntity instanceof WitherBoss) {
            return;
        }
        MobEffectInstance currentEffect = livingEntity.getEffect(CSEffects.SHIMMER_EFFECT);
        if (currentEffect == null || currentEffect.getDuration() < 40) {
            livingEntity.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 80, 0, false, true, true));
        }
    }
}

