/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.mixin;

import com.adonis.createshimmer.util.ScepterRepairHelper;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FillingRecipe.class}, remap=false)
public class FillingRecipeMixin {
    @Inject(method={"matches"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMatches(SingleRecipeInput inv, Level level, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = inv.getItem(0);
        FillingRecipe self = (FillingRecipe)this;
        if (ScepterRepairHelper.isRepairableScepter(stack)) {
            boolean isShimmerRepairRecipe = this.isShimmerRepairRecipe(self);
            if (isShimmerRepairRecipe) {
                boolean exactMatch = this.isExactScepterMatch(self, stack);
                boolean needsRepair = ScepterRepairHelper.needsRepair(stack);
                boolean matches = exactMatch && needsRepair;
                cir.setReturnValue((Object)matches);
                return;
            }
            cir.setReturnValue((Object)false);
            return;
        }
        if (this.isShimmerRepairRecipe(self)) {
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"getRequiredFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetRequiredFluid(CallbackInfoReturnable<SizedFluidIngredient> cir) {
        FillingRecipe self = (FillingRecipe)this;
        if (self.getFluidIngredients().isEmpty() && this.isShimmerRepairRecipeByItems(self)) {
            try {
                Fluid shimmerFluid = this.getShimmerFluid();
                if (shimmerFluid != null) {
                    ItemStack exampleScepter = ((Ingredient)self.getIngredients().get(0)).getItems()[0];
                    FluidStack shimmerStack = new FluidStack(shimmerFluid, ScepterRepairHelper.getRepairCost(exampleScepter));
                    SizedFluidIngredient shimmerIngredient = SizedFluidIngredient.of((FluidStack)shimmerStack);
                    cir.setReturnValue((Object)shimmerIngredient);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isExactScepterMatch(FillingRecipe recipe, ItemStack inputStack) {
        try {
            NonNullList ingredients = recipe.getIngredients();
            if (!ingredients.isEmpty()) {
                ItemStack[] items;
                Ingredient ingredient = (Ingredient)ingredients.get(0);
                for (ItemStack recipeItem : items = ingredient.getItems()) {
                    if (recipeItem.getItem() != inputStack.getItem()) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isShimmerRepairRecipe(FillingRecipe recipe) {
        try {
            boolean hasScepterInput = false;
            NonNullList ingredients = recipe.getIngredients();
            if (!ingredients.isEmpty()) {
                ItemStack[] items;
                Ingredient ingredient = (Ingredient)ingredients.get(0);
                for (ItemStack item : items = ingredient.getItems()) {
                    if (!ScepterRepairHelper.isRepairableScepter(item)) continue;
                    hasScepterInput = true;
                    break;
                }
            }
            if (!hasScepterInput) {
                return false;
            }
            if (!recipe.getFluidIngredients().isEmpty()) {
                FluidStack[] matchingFluids;
                SizedFluidIngredient sizedFluidIngredient = (SizedFluidIngredient)recipe.getFluidIngredients().get(0);
                FluidIngredient fluidIngredient = sizedFluidIngredient.ingredient();
                for (FluidStack fluidStack : matchingFluids = fluidIngredient.getStacks()) {
                    ResourceLocation fluidName = BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid());
                    if (fluidName == null || !fluidName.toString().contains("shimmer")) continue;
                    return true;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isShimmerRepairRecipeByItems(FillingRecipe recipe) {
        try {
            NonNullList ingredients = recipe.getIngredients();
            if (!ingredients.isEmpty()) {
                ItemStack[] items;
                Ingredient ingredient = (Ingredient)ingredients.get(0);
                for (ItemStack item : items = ingredient.getItems()) {
                    if (!ScepterRepairHelper.isRepairableScepter(item)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Fluid getShimmerFluid() {
        try {
            return (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"create_shimmer", (String)"shimmer"));
        }
        catch (Exception e) {
            return null;
        }
    }
}

