/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tn.mbs.memory.MemoryOfThePastMod;
import tn.mbs.memory.init.MemoryOfThePastModScreens;
import tn.mbs.memory.network.MenuStateUpdateMessage;
import tn.mbs.memory.world.inventory.PlayerAttributesViewerGUIMenu;
import tn.mbs.memory.world.inventory.PlayerStatsGUIMenu;

public class MemoryOfThePastModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"memory_of_the_past");
    public static final RegistryObject<MenuType<PlayerStatsGUIMenu>> PLAYER_STATS_GUI = REGISTRY.register("player_stats_gui", () -> IForgeMenuType.create(PlayerStatsGUIMenu::new));
    public static final RegistryObject<MenuType<PlayerAttributesViewerGUIMenu>> PLAYER_ATTRIBUTES_VIEWER_GUI = REGISTRY.register("player_attributes_viewer_gui", () -> IForgeMenuType.create(PlayerAttributesViewerGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MemoryOfThePastMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.f_19853_.f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof MemoryOfThePastModScreens.ScreenAccessor) {
                    MemoryOfThePastModScreens.ScreenAccessor accessor = (MemoryOfThePastModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                MemoryOfThePastMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

