/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.ras.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tn.nightbeam.ras.RpgAttributeSystemMod;
import tn.nightbeam.ras.procedures.AddModiferCountProcedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute10Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute1Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute2Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute3Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute4Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute5Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute6Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute7Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute8Procedure;
import tn.nightbeam.ras.procedures.AddPointsAttribute9Procedure;
import tn.nightbeam.ras.procedures.OpenAttributesDisplayGUIProcedure;
import tn.nightbeam.ras.procedures.RemoveModiferCountProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record PlayerStatsGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerStatsGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rpg_attribute_system", (String)"player_stats_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerStatsGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new PlayerStatsGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<PlayerStatsGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(PlayerStatsGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> PlayerStatsGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AddPointsAttribute1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            AddPointsAttribute2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            AddPointsAttribute3Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            AddPointsAttribute4Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            AddPointsAttribute5Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            AddPointsAttribute6Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            AddPointsAttribute7Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            AddPointsAttribute8Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            AddPointsAttribute10Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 9) {
            OpenAttributesDisplayGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            RemoveModiferCountProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            AddModiferCountProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            AddPointsAttribute9Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RpgAttributeSystemMod.addNetworkMessage(TYPE, STREAM_CODEC, PlayerStatsGUIButtonMessage::handleData);
    }
}

