/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tn.mbs.memory.init.MemoryOfThePastModScreens;
import tn.mbs.memory.network.MenuStateUpdateMessage;
import tn.mbs.memory.world.inventory.PlayerAttributesViewerGUIMenu;
import tn.mbs.memory.world.inventory.PlayerStatsGUIMenu;

public class MemoryOfThePastModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"memory_of_the_past");
    public static final DeferredHolder<MenuType<?>, MenuType<PlayerStatsGUIMenu>> PLAYER_STATS_GUI = REGISTRY.register("player_stats_gui", () -> IMenuTypeExtension.create(PlayerStatsGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<PlayerAttributesViewerGUIMenu>> PLAYER_ATTRIBUTES_VIEWER_GUI = REGISTRY.register("player_attributes_viewer_gui", () -> IMenuTypeExtension.create(PlayerAttributesViewerGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof MemoryOfThePastModScreens.ScreenAccessor) {
                    MemoryOfThePastModScreens.ScreenAccessor accessor = (MemoryOfThePastModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

