/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import tn.mbs.memory.MemoryOfThePastMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MemoryOfThePastModVariables {
    @CapabilityInject(value=PlayerVariables.class)
    public static Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = null;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PlayerVariables.class, (Capability.IStorage)new PlayerVariablesStorage(), PlayerVariables::new);
        MemoryOfThePastMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(PacketBuffer buffer) {
            this.data = new PlayerVariables();
            new PlayerVariablesStorage().readNBT(null, this.data, null, (INBT)buffer.func_150793_b());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, PacketBuffer buffer) {
            buffer.func_150786_a((CompoundNBT)new PlayerVariablesStorage().writeNBT(null, message.data, null));
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.func_71410_x().field_71439_g.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.attribute_1 = message.data.attribute_1;
                    variables.attribute_6 = message.data.attribute_6;
                    variables.attribute_5 = message.data.attribute_5;
                    variables.attribute_2 = message.data.attribute_2;
                    variables.attribute_4 = message.data.attribute_4;
                    variables.attribute_3 = message.data.attribute_3;
                    variables.Level = message.data.Level;
                    variables.SparePoints = message.data.SparePoints;
                    variables.currentXpTLevel = message.data.currentXpTLevel;
                    variables.nextevelXp = message.data.nextevelXp;
                    variables.attribute_7 = message.data.attribute_7;
                    variables.attribute_8 = message.data.attribute_8;
                    variables.attribute_9 = message.data.attribute_9;
                    variables.attribute_10 = message.data.attribute_10;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double attribute_1 = 20.0;
        public double attribute_6 = 0.0;
        public double attribute_5 = 0.1;
        public double attribute_2 = 2.0;
        public double attribute_4 = 0.0;
        public double attribute_3 = 4.0;
        public double Level = 0.0;
        public double SparePoints = 1.0;
        public double currentXpTLevel = 0.0;
        public double nextevelXp = 100.0;
        public double attribute_7 = 0.0;
        public double attribute_8 = 0.0;
        public double attribute_9 = 0.0;
        public double attribute_10 = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayerEntity) {
                MemoryOfThePastMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new PlayerVariablesSyncMessage(this));
            }
        }
    }

    private static class PlayerVariablesStorage
    implements Capability.IStorage<PlayerVariables> {
        private PlayerVariablesStorage() {
        }

        public INBT writeNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74780_a("attribute_1", instance.attribute_1);
            nbt.func_74780_a("attribute_6", instance.attribute_6);
            nbt.func_74780_a("attribute_5", instance.attribute_5);
            nbt.func_74780_a("attribute_2", instance.attribute_2);
            nbt.func_74780_a("attribute_4", instance.attribute_4);
            nbt.func_74780_a("attribute_3", instance.attribute_3);
            nbt.func_74780_a("Level", instance.Level);
            nbt.func_74780_a("SparePoints", instance.SparePoints);
            nbt.func_74780_a("currentXpTLevel", instance.currentXpTLevel);
            nbt.func_74780_a("nextevelXp", instance.nextevelXp);
            nbt.func_74780_a("attribute_7", instance.attribute_7);
            nbt.func_74780_a("attribute_8", instance.attribute_8);
            nbt.func_74780_a("attribute_9", instance.attribute_9);
            nbt.func_74780_a("attribute_10", instance.attribute_10);
            return nbt;
        }

        public void readNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side, INBT inbt) {
            CompoundNBT nbt = (CompoundNBT)inbt;
            instance.attribute_1 = nbt.func_74769_h("attribute_1");
            instance.attribute_6 = nbt.func_74769_h("attribute_6");
            instance.attribute_5 = nbt.func_74769_h("attribute_5");
            instance.attribute_2 = nbt.func_74769_h("attribute_2");
            instance.attribute_4 = nbt.func_74769_h("attribute_4");
            instance.attribute_3 = nbt.func_74769_h("attribute_3");
            instance.Level = nbt.func_74769_h("Level");
            instance.SparePoints = nbt.func_74769_h("SparePoints");
            instance.currentXpTLevel = nbt.func_74769_h("currentXpTLevel");
            instance.nextevelXp = nbt.func_74769_h("nextevelXp");
            instance.attribute_7 = nbt.func_74769_h("attribute_7");
            instance.attribute_8 = nbt.func_74769_h("attribute_8");
            instance.attribute_9 = nbt.func_74769_h("attribute_9");
            instance.attribute_10 = nbt.func_74769_h("attribute_10");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<INBT> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("memory_of_the_past", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PLAYER_VARIABLES_CAPABILITY.getStorage().writeNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_VARIABLES_CAPABILITY.getStorage().readNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null, nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().field_70170_p.func_201670_d()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().field_70170_p.func_201670_d()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().field_70170_p.func_201670_d()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.attribute_1 = original.attribute_1;
            clone.attribute_6 = original.attribute_6;
            clone.attribute_5 = original.attribute_5;
            clone.attribute_2 = original.attribute_2;
            clone.attribute_4 = original.attribute_4;
            clone.attribute_3 = original.attribute_3;
            clone.Level = original.Level;
            clone.SparePoints = original.SparePoints;
            clone.currentXpTLevel = original.currentXpTLevel;
            clone.nextevelXp = original.nextevelXp;
            clone.attribute_7 = original.attribute_7;
            clone.attribute_8 = original.attribute_8;
            clone.attribute_9 = original.attribute_9;
            clone.attribute_10 = original.attribute_10;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

