/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import tn.mbs.memory.MemoryOfThePastMod;
import tn.mbs.memory.procedures.OpenStatsMenuProcedure;
import tn.mbs.memory.world.inventory.PlayerAttributesViewerGUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlayerAttributesViewerGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PlayerAttributesViewerGUIButtonMessage(PacketBuffer buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PlayerAttributesViewerGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PlayerAttributesViewerGUIButtonMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PlayerAttributesViewerGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PlayerAttributesViewerGUIButtonMessage.handleButtonAction((PlayerEntity)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z) {
        World world = entity.field_70170_p;
        HashMap<String, Object> guistate = PlayerAttributesViewerGUIMenu.guistate;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenStatsMenuProcedure.execute((IWorld)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MemoryOfThePastMod.addNetworkMessage(PlayerAttributesViewerGUIButtonMessage.class, PlayerAttributesViewerGUIButtonMessage::buffer, PlayerAttributesViewerGUIButtonMessage::new, PlayerAttributesViewerGUIButtonMessage::handler);
    }
}

