/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import tn.mbs.memory.MemoryOfThePastMod;
import tn.mbs.memory.procedures.AddPointsAttributeEightProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeFifthProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeForthProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeNineProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeOneProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeSeventhProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeSixthProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeTenProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeThreeProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeTwoProcedure;
import tn.mbs.memory.procedures.OpenAttributesDisplayGUIProcedure;
import tn.mbs.memory.world.inventory.PlayerStatsGUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlayerStatsGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PlayerStatsGUIButtonMessage(PacketBuffer buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PlayerStatsGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PlayerStatsGUIButtonMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PlayerStatsGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PlayerStatsGUIButtonMessage.handleButtonAction((PlayerEntity)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z) {
        World world = entity.field_70170_p;
        HashMap<String, Object> guistate = PlayerStatsGUIMenu.guistate;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AddPointsAttributeOneProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            AddPointsAttributeTwoProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            AddPointsAttributeThreeProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            AddPointsAttributeForthProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            AddPointsAttributeFifthProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            AddPointsAttributeSixthProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            AddPointsAttributeSeventhProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            AddPointsAttributeEightProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            AddPointsAttributeNineProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            AddPointsAttributeTenProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            OpenAttributesDisplayGUIProcedure.execute((IWorld)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MemoryOfThePastMod.addNetworkMessage(PlayerStatsGUIButtonMessage.class, PlayerStatsGUIButtonMessage::buffer, PlayerStatsGUIButtonMessage::new, PlayerStatsGUIButtonMessage::handler);
    }
}

