/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import tn.mbs.memory.MemoryOfThePastMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MemoryOfThePastModVariables {
    public static double counter = 0.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MemoryOfThePastMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.attribute_1 = message.data.attribute_1;
                    variables.attribute_6 = message.data.attribute_6;
                    variables.attribute_5 = message.data.attribute_5;
                    variables.attribute_2 = message.data.attribute_2;
                    variables.attribute_4 = message.data.attribute_4;
                    variables.attribute_3 = message.data.attribute_3;
                    variables.Level = message.data.Level;
                    variables.SparePoints = message.data.SparePoints;
                    variables.currentXpTLevel = message.data.currentXpTLevel;
                    variables.nextevelXp = message.data.nextevelXp;
                    variables.attribute_7 = message.data.attribute_7;
                    variables.attribute_8 = message.data.attribute_8;
                    variables.attribute_9 = message.data.attribute_9;
                    variables.attribute_10 = message.data.attribute_10;
                    variables.modifier = message.data.modifier;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double attribute_1 = 20.0;
        public double attribute_6 = 0.0;
        public double attribute_5 = 0.1;
        public double attribute_2 = 2.0;
        public double attribute_4 = 0.0;
        public double attribute_3 = 4.0;
        public double Level = 0.0;
        public double SparePoints = 1.0;
        public double currentXpTLevel = 0.0;
        public double nextevelXp = 100.0;
        public double attribute_7 = 0.0;
        public double attribute_8 = 0.0;
        public double attribute_9 = 0.0;
        public double attribute_10 = 0.0;
        public double modifier = 1.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MemoryOfThePastMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("attribute_1", this.attribute_1);
            nbt.m_128347_("attribute_6", this.attribute_6);
            nbt.m_128347_("attribute_5", this.attribute_5);
            nbt.m_128347_("attribute_2", this.attribute_2);
            nbt.m_128347_("attribute_4", this.attribute_4);
            nbt.m_128347_("attribute_3", this.attribute_3);
            nbt.m_128347_("Level", this.Level);
            nbt.m_128347_("SparePoints", this.SparePoints);
            nbt.m_128347_("currentXpTLevel", this.currentXpTLevel);
            nbt.m_128347_("nextevelXp", this.nextevelXp);
            nbt.m_128347_("attribute_7", this.attribute_7);
            nbt.m_128347_("attribute_8", this.attribute_8);
            nbt.m_128347_("attribute_9", this.attribute_9);
            nbt.m_128347_("attribute_10", this.attribute_10);
            nbt.m_128347_("modifier", this.modifier);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.attribute_1 = nbt.m_128459_("attribute_1");
            this.attribute_6 = nbt.m_128459_("attribute_6");
            this.attribute_5 = nbt.m_128459_("attribute_5");
            this.attribute_2 = nbt.m_128459_("attribute_2");
            this.attribute_4 = nbt.m_128459_("attribute_4");
            this.attribute_3 = nbt.m_128459_("attribute_3");
            this.Level = nbt.m_128459_("Level");
            this.SparePoints = nbt.m_128459_("SparePoints");
            this.currentXpTLevel = nbt.m_128459_("currentXpTLevel");
            this.nextevelXp = nbt.m_128459_("nextevelXp");
            this.attribute_7 = nbt.m_128459_("attribute_7");
            this.attribute_8 = nbt.m_128459_("attribute_8");
            this.attribute_9 = nbt.m_128459_("attribute_9");
            this.attribute_10 = nbt.m_128459_("attribute_10");
            this.modifier = nbt.m_128459_("modifier");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("memory_of_the_past", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.attribute_1 = original.attribute_1;
            clone.attribute_6 = original.attribute_6;
            clone.attribute_5 = original.attribute_5;
            clone.attribute_2 = original.attribute_2;
            clone.attribute_4 = original.attribute_4;
            clone.attribute_3 = original.attribute_3;
            clone.Level = original.Level;
            clone.SparePoints = original.SparePoints;
            clone.currentXpTLevel = original.currentXpTLevel;
            clone.nextevelXp = original.nextevelXp;
            clone.attribute_7 = original.attribute_7;
            clone.attribute_8 = original.attribute_8;
            clone.attribute_9 = original.attribute_9;
            clone.attribute_10 = original.attribute_10;
            clone.modifier = original.modifier;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

