/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import tn.mbs.memory.MemoryOfThePastMod;
import tn.mbs.memory.init.MemoryOfThePastModScreens;
import tn.mbs.memory.network.MenuStateUpdateMessage;
import tn.mbs.memory.world.inventory.PlayerAttributesViewerGUIMenu;
import tn.mbs.memory.world.inventory.PlayerStatsGUIMenu;

public class MemoryOfThePastModMenus {
    public static final DeferredRegister<ContainerType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"memory_of_the_past");
    public static final RegistryObject<ContainerType<PlayerStatsGUIMenu>> PLAYER_STATS_GUI = REGISTRY.register("player_stats_gui", () -> IForgeContainerType.create(PlayerStatsGUIMenu::new));
    public static final RegistryObject<ContainerType<PlayerAttributesViewerGUIMenu>> PLAYER_ATTRIBUTES_VIEWER_GUI = REGISTRY.register("player_attributes_viewer_gui", () -> IForgeContainerType.create(PlayerAttributesViewerGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(PlayerEntity player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayerEntity) {
                MemoryOfThePastMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.field_70170_p.field_72995_K) {
                if (Minecraft.func_71410_x().field_71462_r instanceof MemoryOfThePastModScreens.ScreenAccessor && needClientUpdate) {
                    ((MemoryOfThePastModScreens.ScreenAccessor)Minecraft.func_71410_x().field_71462_r).updateMenuState(elementType, name, elementState);
                }
                MemoryOfThePastMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

