/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp;

import com.github.squi2rel.vp.VideoPlayerClient;
import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.network.ByteBufUtils;
import com.github.squi2rel.vp.network.PacketID;
import com.github.squi2rel.vp.network.ServerPacketHandler;
import com.github.squi2rel.vp.network.VideoPayload;
import com.github.squi2rel.vp.provider.NamedProviderSource;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.provider.VideoProviders;
import com.github.squi2rel.vp.video.ClientVideoArea;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.IVideoPlayer;
import com.github.squi2rel.vp.video.VideoScreen;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler {
    public static void handle(ByteBuf buf) {
        short type = buf.readUnsignedByte();
        switch (type) {
            case 0: {
                String version = ByteBufUtils.readString(buf, 16);
                if (!VideoPlayerClient.checkVersion(version)) {
                    Objects.requireNonNull(class_310.method_1551().field_1724).method_7353(class_2561.method_30163((String)("\u670d\u52a1\u5668VideoPlayer\u7248\u672c\u548c\u672c\u5730\u7248\u672c\u4e0d\u5339\u914d! \u672c\u5730\u7248\u672c\u4e3a" + VideoPlayerMain.version + ", \u670d\u52a1\u5668\u7248\u672c\u4e3a" + version)), false);
                    return;
                }
                VideoPlayerClient.remoteControlName = ByteBufUtils.readString(buf, 256);
                VideoPlayerClient.remoteControlId = buf.readFloat();
                VideoPlayerClient.remoteControlRange = buf.readFloat();
                VideoPlayerClient.noControlRange = buf.readFloat();
                VideoPlayerClient.connected = true;
                ClientPacketHandler.config(VideoPlayerMain.version);
                break;
            }
            case 1: {
                ClientVideoScreen screen = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf)).getScreen(ClientPacketHandler.readName(buf));
                VideoInfo info = VideoInfo.read(buf);
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return;
                }
                if (screen.player != null) {
                    screen.player.stop();
                }
                if (info.rawPath().isEmpty()) {
                    screen.play(info);
                    return;
                }
                CompletableFuture<VideoInfo> video = VideoProviders.from(info.rawPath(), new NamedProviderSource(info.playerName()));
                if (video == null) {
                    player.method_7353(class_2561.method_30163((String)"\u65e0\u6cd5\u89e3\u6790\u89c6\u9891\u6e90"), false);
                    return;
                }
                CompletableFuture.supplyAsync(() -> {
                    try {
                        return (VideoInfo)video.get();
                    }
                    catch (Exception e) {
                        VideoPlayerMain.LOGGER.error(e.toString());
                        return null;
                    }
                }).thenAccept(v -> {
                    try {
                        if (v == null) {
                            player.method_7353(class_2561.method_30163((String)"\u65e0\u6cd5\u89e3\u6790\u89c6\u9891\u6e90"), false);
                            return;
                        }
                        class_310.method_1551().execute(() -> screen.play(new VideoInfo(info.playerName(), info.name(), v.path(), v.rawPath(), v.expire(), v.seekable(), info.params())));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                break;
            }
            case 2: {
                String areaName = ClientPacketHandler.readName(buf);
                String name = ByteBufUtils.readString(buf, 32);
                VideoPlayerClient.areas.get(areaName).getScreen(name).setProgress(buf.readLong());
                break;
            }
            case 3: {
                VideoPlayerClient.areas.put(ClientPacketHandler.readName(buf), ClientVideoArea.read(buf));
                break;
            }
            case 4: {
                VideoPlayerClient.areas.remove(ClientPacketHandler.readName(buf)).remove();
                break;
            }
            case 5: {
                ClientVideoArea area = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf));
                int size = buf.readUnsignedByte();
                for (int i = 0; i < size; ++i) {
                    ClientVideoScreen screen = ClientVideoScreen.from(VideoScreen.read(buf, area));
                    ServerPacketHandler.readUV(buf, screen);
                    screen.readMeta(buf);
                    area.addScreen(screen);
                }
                break;
            }
            case 6: {
                VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf)).remove(ClientPacketHandler.readName(buf));
                break;
            }
            case 7: {
                ClientVideoArea area = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf));
                while (buf.readableBytes() != 0) {
                    ClientVideoScreen screen = area.getScreen(ClientPacketHandler.readName(buf));
                    screen.setToPlay(VideoInfo.read(buf));
                    screen.setToSeek(buf.readLong());
                }
                area.load();
                break;
            }
            case 8: {
                VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf)).unload();
                break;
            }
            case 9: {
                ClientVideoArea area = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                int size = buf.readUnsignedByte();
                for (int i = 0; i < size; ++i) {
                    ClientVideoScreen screen = area.getScreen(ClientPacketHandler.readName(buf));
                    int len = buf.readUnsignedByte();
                    VideoInfo[] infos = new VideoInfo[len];
                    for (int j = 0; j < len; ++j) {
                        infos[j] = new VideoInfo(ByteBufUtils.readString(buf, 256), ByteBufUtils.readString(buf, 256), null, null, -1L, false, null);
                    }
                    screen.updatePlaylist(infos);
                }
                break;
            }
            case 10: {
                ClientVideoScreen screen = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf)).getScreen(ClientPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                IVideoPlayer player = screen.player;
                if (player == null) {
                    return;
                }
                class_310.method_1551().execute(player::stop);
                break;
            }
            case 12: {
                class_310 client = class_310.method_1551();
                CommandDispatcher dispatcher = ClientCommandManager.getActiveDispatcher();
                if (dispatcher == null || client.field_1724 == null) break;
                try {
                    dispatcher.execute("vlc " + ByteBufUtils.readString(buf, 1024), (Object)((FabricClientCommandSource)client.field_1724.field_3944.method_2875()));
                }
                catch (CommandSyntaxException e) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u6267\u884c\u6307\u4ee4\u5931\u8d25: " + String.valueOf((Object)e))).method_27692(class_124.field_1061), false);
                }
                break;
            }
            case 14: {
                ClientVideoScreen screen = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf)).getScreen(ClientPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                ServerPacketHandler.readUV(buf, screen);
                break;
            }
            case 16: {
                short i = buf.readUnsignedByte();
                if (i >= PacketID.Action.VALUES.length) {
                    VideoPlayerMain.LOGGER.warn("Unknown action type: {}", (Object)i);
                    return;
                }
                PacketID.Action action = PacketID.Action.VALUES[i];
                ClientVideoScreen screen = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf)).getScreen(ClientPacketHandler.readName(buf));
                action.apply(screen, buf.readInt());
                screen.metaChanged();
                break;
            }
            case 17: {
                ClientVideoScreen screen = VideoPlayerClient.areas.get(ClientPacketHandler.readName(buf)).getScreen(ClientPacketHandler.readName(buf));
                String key = ClientPacketHandler.readName(buf);
                int value = buf.readInt();
                boolean remove = buf.readBoolean();
                if (remove) {
                    screen.meta.remove(key);
                } else {
                    screen.meta.put(key, value);
                }
                screen.metaChanged();
                break;
            }
            default: {
                VideoPlayerMain.LOGGER.warn("Unknown packet type: {}", (Object)type);
            }
        }
        if (buf.readableBytes() > 0) {
            VideoPlayerMain.LOGGER.warn("Bytes remaining: {}, type {}", (Object)buf.readableBytes(), (Object)type);
        }
    }

    private static String readName(ByteBuf buf) {
        return ByteBufUtils.readString(buf, 32);
    }

    private static ByteBuf create(int id) {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer();
        buf.writeByte((int)((byte)id));
        return buf;
    }

    private static byte[] toByteArray(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        buf.release();
        return bytes;
    }

    private static void send(byte[] bytes) {
        ClientPlayNetworking.send((class_8710)new VideoPayload(bytes));
    }

    public static void config(String version) {
        ByteBuf buf = ClientPacketHandler.create(0);
        ByteBufUtils.writeString(buf, version);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void request(VideoScreen screen, String path) {
        ByteBuf buf = ClientPacketHandler.create(1);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        ByteBufUtils.writeString(buf, path);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void sync(VideoScreen screen) {
        ByteBuf buf = ClientPacketHandler.create(2);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void createArea(Vector3f p1, Vector3f p2, String name) {
        ByteBuf buf = ClientPacketHandler.create(3);
        ByteBufUtils.writeVec3(buf, p1);
        ByteBufUtils.writeVec3(buf, p2);
        ByteBufUtils.writeString(buf, name);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void removeArea(String area) {
        ByteBuf buf = ClientPacketHandler.create(4);
        ByteBufUtils.writeString(buf, area);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void createScreen(VideoScreen screen) {
        ByteBuf buf = ClientPacketHandler.create(5);
        ByteBufUtils.writeString(buf, screen.area.name);
        VideoScreen.write(buf, screen);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void removeScreen(VideoScreen screen) {
        ByteBuf buf = ClientPacketHandler.create(6);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void skip(VideoScreen screen, boolean force) {
        ByteBuf buf = ClientPacketHandler.create(10);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        buf.writeBoolean(force);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void skipPercent(VideoScreen screen, float percent) {
        ByteBuf buf = ClientPacketHandler.create(11);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        buf.writeFloat(percent);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void idlePlay(VideoScreen screen, String url) {
        ByteBuf buf = ClientPacketHandler.create(13);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        ByteBufUtils.writeString(buf, url);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void slice(VideoScreen screen, float u1, float v1, float u2, float v2) {
        ClientPacketHandler.send(ServerPacketHandler.slice(screen, u1, v1, u2, v2));
    }

    public static void openMenu(VideoScreen screen) {
        ByteBuf buf = ClientPacketHandler.create(15);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        ClientPacketHandler.send(ClientPacketHandler.toByteArray(buf));
    }

    public static void setMeta(VideoScreen screen, int actionId, int value) {
        ClientPacketHandler.send(ServerPacketHandler.setMeta(screen, actionId, value));
    }

    public static void setCustomMeta(VideoScreen screen, String key, int value, boolean remove) {
        ClientPacketHandler.send(ServerPacketHandler.setCustomMeta(screen, key, value, remove));
    }
}

