/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp;

import com.github.squi2rel.vp.ServerConfig;
import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.network.ServerPacketHandler;
import com.github.squi2rel.vp.video.VideoArea;
import com.github.squi2rel.vp.video.VideoScreen;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class DataHolder {
    public static ServerConfig config = new ServerConfig();
    public static ArrayList<UUID> allPlayers = new ArrayList();
    public static HashMap<UUID, String> playerDim = new HashMap();
    public static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("videoplayer.json");
    public static HashMap<String, HashMap<String, VideoArea>> areas = new HashMap();
    private static final Gson gson = new Gson();
    private static final ReentrantLock lock = new ReentrantLock();
    public static MinecraftServer server;

    public static void update() {
        String dim;
        class_3222 player;
        class_3324 pm = server.method_3760();
        DataHolder.lock();
        for (UUID uUID : allPlayers) {
            HashMap<String, VideoArea> all;
            player = pm.method_14602(uUID);
            if (player == null || (all = areas.get(dim = player.method_51469().method_27983().method_29177().toString())) == null || all.isEmpty()) continue;
            for (VideoArea area : all.values()) {
                if (area.inBounds(player.method_19538())) {
                    if (!area.addPlayer(player.method_5667())) continue;
                    ServerPacketHandler.sendTo(player, ServerPacketHandler.createArea(area));
                    if (area.screens.isEmpty()) {
                        ServerPacketHandler.sendTo(player, ServerPacketHandler.loadArea(area));
                        continue;
                    }
                    ServerPacketHandler.sendTo(player, ServerPacketHandler.createScreen(area.screens));
                    ServerPacketHandler.sendTo(player, ServerPacketHandler.loadArea(area));
                    ServerPacketHandler.sendTo(player, ServerPacketHandler.updatePlaylist(area.screens));
                    continue;
                }
                if (!area.removePlayer(player.method_5667())) continue;
                ServerPacketHandler.sendTo(player, ServerPacketHandler.unloadArea(area));
                ServerPacketHandler.sendTo(player, ServerPacketHandler.removeArea(area));
            }
        }
        for (Map.Entry entry : playerDim.entrySet()) {
            HashMap<String, VideoArea> map;
            player = pm.method_14602((UUID)entry.getKey());
            if (player == null || (dim = player.method_51469().method_27983().method_29177().toString()).equals(entry.getValue()) || (map = areas.get(entry.getValue())) == null) continue;
            for (VideoArea area : map.values()) {
                if (!area.removePlayer(player.method_5667())) continue;
                ServerPacketHandler.sendTo(player, ServerPacketHandler.unloadArea(area));
                ServerPacketHandler.sendTo(player, ServerPacketHandler.removeArea(area));
            }
        }
        for (class_3222 class_32222 : PlayerLookup.all((MinecraftServer)server)) {
            playerDim.put(class_32222.method_5667(), class_32222.method_51469().method_27983().method_29177().toString());
        }
        DataHolder.unlock();
    }

    public static void lock() {
        lock.lock();
    }

    public static void unload(MinecraftServer s) {
        class_3324 pm = s.method_3760();
        DataHolder.lock();
        for (HashMap<String, VideoArea> map : areas.values()) {
            for (VideoArea area : map.values()) {
                if (!area.hasPlayer()) continue;
                byte[] data = ServerPacketHandler.removeArea(area);
                area.forEachPlayer(u -> ServerPacketHandler.sendTo(pm.method_14602(u), data));
            }
        }
        DataHolder.unlock();
    }

    public static void playerJoin(class_3222 player) {
        ServerPacketHandler.sendTo(player, ServerPacketHandler.config(VideoPlayerMain.version, config));
    }

    public static void playerLeave(UUID uuid) {
        DataHolder.lock();
        allPlayers.remove(uuid);
        playerDim.remove(uuid);
        DataHolder.unlock();
        CompletableFuture.runAsync(() -> {
            lock.lock();
            for (HashMap<String, VideoArea> value : areas.values()) {
                for (VideoArea area : value.values()) {
                    area.removePlayer(uuid);
                }
            }
            lock.unlock();
        });
    }

    public static void unlock() {
        lock.unlock();
    }

    public static void stop(MinecraftServer server) {
        DataHolder.save();
        DataHolder.unload(server);
    }

    public static void save() {
        DataHolder.lock();
        ArrayList<VideoArea> all = new ArrayList<VideoArea>();
        for (HashMap<String, VideoArea> child : areas.values()) {
            all.addAll(child.values());
        }
        DataHolder.config.areas = all;
        DataHolder.writeString(configPath, gson.toJson((Object)config));
        DataHolder.unlock();
    }

    public static void load(MinecraftServer server) {
        DataHolder.server = server;
        DataHolder.lock();
        try {
            config = (ServerConfig)gson.fromJson(DataHolder.readString(configPath), ServerConfig.class);
        }
        catch (Exception e) {
            config = new ServerConfig();
            DataHolder.save();
        }
        for (VideoArea area : DataHolder.config.areas) {
            for (VideoScreen screen : area.screens) {
                if (screen.meta != null) continue;
                screen.meta = new HashMap<String, Integer>();
            }
            area.initServer();
            area.afterLoad();
            areas.computeIfAbsent(area.dim, k -> new HashMap()).put(area.name, area);
        }
        DataHolder.config.areas = null;
        DataHolder.unlock();
    }

    public static String readString(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeString(Path path, String str) {
        try {
            Files.writeString(path, (CharSequence)str, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

