/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp;

import com.github.squi2rel.vp.video.ClientVideoScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class Intersection {
    public static Result intersect(Vector3f lineStart, Vector3f lineEnd, ClientVideoScreen player) {
        Vector3f p1 = player.p1;
        Vector3f p2 = player.p2;
        Vector3f p3 = player.p3;
        Vector3f p4 = player.p4;
        Result result = new Result();
        Vector3f edge1 = new Vector3f();
        Vector3f edge2 = new Vector3f();
        Vector3f normal = new Vector3f();
        p2.sub((Vector3fc)p1, edge1);
        p3.sub((Vector3fc)p1, edge2);
        edge1.cross((Vector3fc)edge2, normal);
        normal.normalize();
        float d = normal.dot((Vector3fc)p1);
        Vector3f lineDir = new Vector3f();
        lineEnd.sub((Vector3fc)lineStart, lineDir);
        float length = lineDir.length();
        lineDir.normalize();
        float denom = normal.dot((Vector3fc)lineDir);
        if (denom >= -1.0E-6f) {
            return result;
        }
        float distance = (d - normal.dot((Vector3fc)lineStart)) / denom;
        if (distance < 0.0f || distance > length) {
            return result;
        }
        result.point.set((Vector3fc)lineDir).mul(distance).add((Vector3fc)lineStart);
        if (Intersection.inTri(result.point, p1, p2, p3) || Intersection.inTri(result.point, p1, p3, p4)) {
            result.intersects = true;
            result.distance = distance;
            result.screen = player;
        }
        return result;
    }

    private static boolean inTri(Vector3f p, Vector3f a, Vector3f b, Vector3f c) {
        Vector3f v0 = new Vector3f((Vector3fc)c).sub((Vector3fc)a);
        Vector3f v1 = new Vector3f((Vector3fc)b).sub((Vector3fc)a);
        Vector3f v2 = new Vector3f((Vector3fc)p).sub((Vector3fc)a);
        float dot00 = v0.dot((Vector3fc)v0);
        float dot01 = v0.dot((Vector3fc)v1);
        float dot02 = v0.dot((Vector3fc)v2);
        float dot11 = v1.dot((Vector3fc)v1);
        float dot12 = v1.dot((Vector3fc)v2);
        float denom = dot00 * dot11 - dot01 * dot01;
        if (denom == 0.0f) {
            return false;
        }
        float invDenom = 1.0f / denom;
        float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0f && v >= 0.0f && u + v <= 1.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Result {
        public boolean intersects = false;
        public Vector3f point = new Vector3f();
        public float distance = 0.0f;
        public ClientVideoScreen screen;
    }
}

