/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp;

import com.github.squi2rel.vp.CameraRenderer;
import com.github.squi2rel.vp.VideoPlayerClient;
import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.vivecraft.Vivecraft;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_10209;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class ScreenRenderer {
    private static final HashMap<Integer, class_1921> quadsCache = new HashMap();
    private static int triangleId;
    private static final class_1921 VIDEO_TRIANGLES;
    private static final Quaternionf rotation;
    public static float cameraX;
    public static float cameraY;
    public static float cameraZ;
    public static boolean skybox;

    public static void render(WorldRenderContext ctx) {
        if (CameraRenderer.rendering) {
            return;
        }
        skybox = false;
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("video");
        profiler.method_15396("render");
        class_4587 matrices = ctx.matrixStack();
        matrices.method_22903();
        class_243 camera = ctx.camera().method_19326();
        cameraX = (float)camera.field_1352;
        cameraY = (float)camera.field_1351;
        cameraZ = (float)camera.field_1350;
        if (Vivecraft.loaded && Vivecraft.isVRActive()) {
            rotation.setFromNormalized((Matrix4fc)Vivecraft.getRotation()).invert();
        } else {
            ctx.camera().method_23767().invert(rotation);
        }
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)513);
        RenderSystem.disableCull();
        class_4597.class_4598 immediate = (class_4597.class_4598)ctx.consumers();
        quadsCache.clear();
        int old = RenderSystem.getShaderTexture((int)0);
        for (ClientVideoScreen screen : VideoPlayerClient.screens) {
            try {
                screen.draw(matrices, immediate);
            }
            catch (Exception e) {
                VideoPlayerMain.LOGGER.error("Exception while rendering", (Throwable)e);
            }
        }
        RenderSystem.setShaderTexture((int)0, (int)old);
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
        matrices.method_22909();
        profiler.method_15407();
        profiler.method_15407();
    }

    public static class_1921 getLayer(int textureId) {
        return quadsCache.computeIfAbsent(textureId, v -> class_1921.method_24049((String)("video_quad_" + textureId), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)32, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(class_10142.field_53880)).method_34577(new class_4668.class_5939(() -> RenderSystem.setShaderTexture((int)0, (int)textureId), () -> {})).method_23603(class_4668.field_21345).method_23617(true)));
    }

    public static void drawTriangles(int textureId, Runnable r) {
        triangleId = textureId;
        VIDEO_TRIANGLES.method_23516();
        r.run();
        VIDEO_TRIANGLES.method_23518();
    }

    public static void rotateMatrix(class_4587 matrices) {
        matrices.method_22907(rotation);
    }

    static {
        VIDEO_TRIANGLES = class_1921.method_24049((String)"video_triangles", (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27380, (int)4096, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(class_10142.field_53880)).method_23604(class_4668.field_21346).method_34577(new class_4668.class_5939(() -> RenderSystem.setShaderTexture((int)0, (int)triangleId), () -> {})).method_23603(class_4668.field_21345).method_23617(true));
        rotation = new Quaternionf();
    }
}

