/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp;

import com.github.squi2rel.vp.ClientPacketHandler;
import com.github.squi2rel.vp.Config;
import com.github.squi2rel.vp.Intersection;
import com.github.squi2rel.vp.ScreenRenderer;
import com.github.squi2rel.vp.TouchHandler;
import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.network.PacketID;
import com.github.squi2rel.vp.network.VideoPayload;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.provider.VideoProviders;
import com.github.squi2rel.vp.video.ClientVideoArea;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.VideoPlayer;
import com.github.squi2rel.vp.video.VideoScreen;
import com.github.squi2rel.vp.video.VlcDecoder;
import com.github.squi2rel.vp.vivecraft.Vivecraft;
import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10209;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2629;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_3695;
import net.minecraft.class_634;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class VideoPlayerClient
implements ClientModInitializer {
    public static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("videoplayer-client.json");
    public static final class_310 client = class_310.method_1551();
    public static Config config;
    private static final Gson gson;
    public static final HashMap<String, ClientVideoArea> areas;
    public static final ArrayList<ClientVideoScreen> screens;
    private static final TouchHandler touchHandler;
    private static ClientVideoScreen currentLooking;
    private static ClientVideoScreen currentScreen;
    private static boolean isInArea;
    private static class_1259 bossBar;
    private static boolean bossBarAdded;
    private static boolean keyPressed;
    public static boolean connected;
    public static String remoteControlName;
    public static float remoteControlId;
    public static float remoteControlRange;
    public static float noControlRange;
    public static boolean updated;
    public static Runnable disconnectHandler;
    private static final SuggestionProvider<FabricClientCommandSource> SUGGEST_AREAS;
    private static final SuggestionProvider<FabricClientCommandSource> SUGGEST_SCREENS;
    private static final SuggestionProvider<FabricClientCommandSource> SUGGEST_REAL_SCREENS;

    public void onInitializeClient() {
        if (VideoPlayerMain.error != null) {
            ClientPlayConnectionEvents.JOIN.register((h, s, c) -> c.field_1724.method_7353((class_2561)class_2561.method_43470((String)("VideoPlayer\u9519\u8bef: libVLC\u5e93\u52a0\u8f7d\u5931\u8d25\n" + String.valueOf(VideoPlayerMain.error) + "\n\u67e5\u770b\u65e5\u5fd7\u83b7\u53d6\u66f4\u591a\u4fe1\u606f")).method_27692(class_124.field_1061), false));
        }
        VlcDecoder.load();
        VideoPlayerClient.loadConfig();
        VideoProviders.register();
        disconnectHandler = () -> client.execute(() -> {
            connected = false;
            for (ClientVideoArea area : areas.values()) {
                area.remove();
            }
            areas.clear();
            for (ClientVideoScreen screen : screens) {
                screen.cleanup();
            }
            screens.clear();
            currentLooking = null;
        });
        if (Vivecraft.loaded) {
            VideoPlayerMain.LOGGER.info("Found Vivecraft");
        }
        ClientPlayConnectionEvents.JOIN.register((h, s, c) -> {
            if (VideoPlayerClient.config.alwaysConnected) {
                ClientPacketHandler.config(VideoPlayerMain.version);
            }
        });
        WorldRenderEvents.AFTER_SETUP.register(e -> VideoPlayerClient.update());
        WorldRenderEvents.AFTER_ENTITIES.register(ScreenRenderer::render);
        WorldRenderEvents.END.register(e -> VideoPlayerClient.postUpdate());
        ClientPlayNetworking.registerGlobalReceiver(VideoPayload.ID, (p, c) -> client.execute(() -> {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])p.data());
            try {
                ClientPacketHandler.handle(buf);
            }
            catch (Exception e) {
                VideoPlayerMain.LOGGER.error("Exception while handling packet", (Throwable)e);
            }
            finally {
                buf.release();
            }
        }));
        ClientCommandRegistrationCallback.EVENT.register((d, c) -> d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vlc").then(ClientCommandManager.literal((String)"play").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            ClientPacketHandler.request(currentScreen.getScreen(), (String)s.getArgument("url", String.class));
            return 1;
        })))).then(ClientCommandManager.literal((String)"playthat").then(ClientCommandManager.argument((String)"area", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREAS).then(ClientCommandManager.argument((String)"screen", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_REAL_SCREENS).then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ClientPacketHandler.request(screen.getScreen(), (String)s.getArgument("url", String.class));
            return 1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skip").then(ClientCommandManager.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            ClientPacketHandler.skip(currentScreen.getScreen(), (Boolean)s.getArgument("force", Boolean.class));
            return 1;
        }))).then(ClientCommandManager.argument((String)"area", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREAS).then(ClientCommandManager.argument((String)"screen", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_REAL_SCREENS).then(ClientCommandManager.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ClientPacketHandler.skip(screen.getScreen(), (Boolean)s.getArgument("force", Boolean.class));
            return 1;
        }))))).executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            ClientPacketHandler.skip(currentScreen.getScreen(), false);
            return 1;
        }))).then(ClientCommandManager.literal((String)"volume").then(ClientCommandManager.argument((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(s -> {
            int v;
            VideoPlayerClient.config.volume = v = ((Integer)s.getArgument("volume", Integer.class)).intValue();
            VideoPlayerClient.saveConfig();
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u97f3\u91cf\u5df2\u8bbe\u7f6e\u4e3a " + v + "%")).method_27692(class_124.field_1060));
            ClientVideoScreen first = screens.stream().filter(cs -> cs.player instanceof VideoPlayer).findAny().orElse(null);
            if (first == null) {
                return 1;
            }
            first.player.setVolume(v);
            return 1;
        })))).then(ClientCommandManager.literal((String)"createArea").then(ClientCommandManager.argument((String)"x1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"y1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"z1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"x2", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"y2", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"z2", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, false)) {
                return 0;
            }
            ClientPacketHandler.createArea(new Vector3f(((Float)s.getArgument("x1", Float.class)).floatValue(), ((Float)s.getArgument("y1", Float.class)).floatValue(), ((Float)s.getArgument("z1", Float.class)).floatValue()), new Vector3f(((Float)s.getArgument("x2", Float.class)).floatValue(), ((Float)s.getArgument("y2", Float.class)).floatValue(), ((Float)s.getArgument("z2", Float.class)).floatValue()), (String)s.getArgument("name", String.class));
            return 1;
        })))))))))).then(ClientCommandManager.literal((String)"removeArea").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREAS).executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, false)) {
                return 0;
            }
            String name = (String)s.getArgument("name", String.class);
            ClientPacketHandler.removeArea(name);
            return 1;
        })))).then(ClientCommandManager.literal((String)"createScreen").then(ClientCommandManager.argument((String)"area", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREAS).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"x1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"y1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"z1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"x2", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"y2", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"z2", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"x3", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"y3", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"z3", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"x4", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"y4", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"z4", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"source", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_REAL_SCREENS).executes(s -> {
            ClientVideoArea area = this.getArea((CommandContext<FabricClientCommandSource>)s);
            if (area == null) {
                return 0;
            }
            ClientPacketHandler.createScreen(new VideoScreen(area, (String)s.getArgument("name", String.class), new Vector3f(((Float)s.getArgument("x1", Float.class)).floatValue(), ((Float)s.getArgument("y1", Float.class)).floatValue(), ((Float)s.getArgument("z1", Float.class)).floatValue()), new Vector3f(((Float)s.getArgument("x2", Float.class)).floatValue(), ((Float)s.getArgument("y2", Float.class)).floatValue(), ((Float)s.getArgument("z2", Float.class)).floatValue()), new Vector3f(((Float)s.getArgument("x3", Float.class)).floatValue(), ((Float)s.getArgument("y3", Float.class)).floatValue(), ((Float)s.getArgument("z3", Float.class)).floatValue()), new Vector3f(((Float)s.getArgument("x4", Float.class)).floatValue(), ((Float)s.getArgument("y4", Float.class)).floatValue(), ((Float)s.getArgument("z4", Float.class)).floatValue()), (String)s.getArgument("source", String.class)));
            return 1;
        })))))))))))))))))).then(ClientCommandManager.literal((String)"removeScreen").then(ClientCommandManager.argument((String)"area", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREAS).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SCREENS).executes(s -> {
            ClientVideoArea area = this.getArea((CommandContext<FabricClientCommandSource>)s);
            if (area == null) {
                return 0;
            }
            String screenName = (String)s.getArgument("name", String.class);
            ClientVideoScreen screen = area.getScreen(screenName);
            if (screen == null) {
                ((FabricClientCommandSource)s.getSource()).sendFeedback(class_2561.method_30163((String)("\u6ca1\u6709\u540d\u4e3a " + screenName + " \u7684\u5c4f\u5e55")));
                return 0;
            }
            ClientPacketHandler.removeScreen(screen);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"skipPercent").then(ClientCommandManager.argument((String)"percent", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.01f)).executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            ClientPacketHandler.skipPercent(currentScreen, ((Float)s.getArgument("percent", Float.class)).floatValue());
            return 1;
        })))).then(ClientCommandManager.literal((String)"list").executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            String str = VideoPlayerClient.currentScreen.getScreen().infos.stream().map(i -> String.format("%s \u8bf7\u6c42\u73a9\u5bb6: %s", i.name(), i.playerName())).collect(Collectors.joining("\n"));
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u89c2\u5f71\u533a %s \u5c4f\u5e55 %s\n%s".formatted(VideoPlayerClient.currentScreen.area.name, VideoPlayerClient.currentScreen.name, str.isEmpty() ? "\u961f\u5217\u65e0\u89c6\u9891" : str)).method_27692(class_124.field_1065));
            return 1;
        }))).then(ClientCommandManager.literal((String)"sync").executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            ClientPacketHandler.sync(currentScreen);
            return 1;
        }))).then(ClientCommandManager.literal((String)"idleplay").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            ClientPacketHandler.idlePlay(currentScreen, (String)s.getArgument("url", String.class));
            return 1;
        })))).then(ClientCommandManager.literal((String)"brightness").then(ClientCommandManager.argument((String)"brightness", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(s -> {
            VideoPlayerClient.config.brightness = (Integer)s.getArgument("brightness", Integer.class);
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u4eae\u5ea6\u5df2\u8bbe\u7f6e\u4e3a " + VideoPlayerClient.config.brightness + "%")).method_27692(class_124.field_1060));
            VideoPlayerClient.saveConfig();
            return 1;
        })))).then(ClientCommandManager.literal((String)"slice").then(ClientCommandManager.argument((String)"u1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"v1", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"u2", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"v2", (ArgumentType)FloatArgumentType.floatArg()).executes(s -> {
            if (this.checkInvalidLooking((CommandContext<FabricClientCommandSource>)s)) {
                return 0;
            }
            float u1 = ((Float)s.getArgument("u1", Float.class)).floatValue();
            float v1 = ((Float)s.getArgument("v1", Float.class)).floatValue();
            float u2 = ((Float)s.getArgument("u2", Float.class)).floatValue();
            float v2 = ((Float)s.getArgument("v2", Float.class)).floatValue();
            ClientPacketHandler.slice(currentLooking, u1, v1, u2, v2);
            return 1;
        }))))))).then(ClientCommandManager.literal((String)"stop").executes(s -> {
            if (this.checkInvalid((CommandContext<FabricClientCommandSource>)s, true)) {
                return 0;
            }
            VideoPlayerClient.currentScreen.player.stop();
            return 1;
        }))).then(ClientCommandManager.literal((String)"setmeta").then(ClientCommandManager.argument((String)"area", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREAS).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"screen", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SCREENS).then(ClientCommandManager.literal((String)"mute").then(ClientCommandManager.argument((String)"mute", (ArgumentType)BoolArgumentType.bool()).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ClientPacketHandler.setMeta(screen, PacketID.Action.MUTE.ordinal(), (Boolean)s.getArgument("mute", Boolean.class) != false ? 1 : 0);
            return 1;
        })))).then(ClientCommandManager.literal((String)"interactable").then(ClientCommandManager.argument((String)"interactable", (ArgumentType)BoolArgumentType.bool()).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ClientPacketHandler.setMeta(screen, PacketID.Action.INTERACTABLE.ordinal(), (Boolean)s.getArgument("interactable", Boolean.class) != false ? 1 : 0);
            return 1;
        })))).then(ClientCommandManager.literal((String)"aspect").then(ClientCommandManager.argument((String)"aspect", (ArgumentType)FloatArgumentType.floatArg((float)0.0625f, (float)16.0f)).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            float aspect = ((Float)s.getArgument("aspect", Float.class)).floatValue();
            ClientPacketHandler.setMeta(screen, PacketID.Action.ASPECT.ordinal(), Float.floatToIntBits(aspect));
            return 1;
        })))).then(ClientCommandManager.literal((String)"fov").then(ClientCommandManager.argument((String)"fov", (ArgumentType)IntegerArgumentType.integer((int)1, (int)179)).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ClientPacketHandler.setMeta(screen, PacketID.Action.FOV.ordinal(), (Integer)s.getArgument("fov", Integer.class));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"custom").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ClientPacketHandler.setCustomMeta(screen, (String)s.getArgument("key", String.class), (Integer)s.getArgument("value", Integer.class), false);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            String key = (String)s.getArgument("key", String.class);
            ((FabricClientCommandSource)s.getSource()).sendFeedback(class_2561.method_30163((String)(key + "=" + String.valueOf(screen.meta.getOrDefault(key, null)))));
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ClientPacketHandler.setCustomMeta(screen, (String)s.getArgument("key", String.class), -1, true);
            return 1;
        })))).then(ClientCommandManager.literal((String)"list").executes(s -> {
            ClientVideoScreen screen = this.getScreen((CommandContext<FabricClientCommandSource>)s);
            if (screen == null) {
                return 0;
            }
            ((FabricClientCommandSource)s.getSource()).sendFeedback(class_2561.method_30163((String)screen.meta.toString()));
            return 1;
        }))))))));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null || client.field_1755 != null || currentLooking == null) {
                return;
            }
            boolean pressed = client.field_1690.field_1904.method_1434();
            if (pressed && !keyPressed) {
                keyPressed = true;
                if (client.field_1724.method_5998(class_1268.field_5808).method_7960() && client.field_1724.method_5998(class_1268.field_5810).method_7960()) {
                    ClientPacketHandler.openMenu(currentLooking);
                }
            } else if (!pressed) {
                keyPressed = false;
            }
        });
        bossBar = new class_345(UUID.randomUUID(), class_2561.method_30163((String)""), 0.0f, class_1259.class_1260.field_5786, class_1259.class_1261.field_5795, false, false, false);
    }

    private ClientVideoArea getArea(CommandContext<FabricClientCommandSource> s) {
        if (this.checkInvalid(s, false)) {
            return null;
        }
        String name = (String)s.getArgument("area", String.class);
        ClientVideoArea area = areas.get(name);
        if (area == null) {
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u6ca1\u6709\u540d\u4e3a " + name + " \u7684\u89c2\u5f71\u533a")).method_27692(class_124.field_1061));
            return null;
        }
        return area;
    }

    private ClientVideoScreen getScreen(CommandContext<FabricClientCommandSource> s) {
        if (this.checkInvalid(s, false)) {
            return null;
        }
        ClientVideoArea area = this.getArea(s);
        if (area == null) {
            return null;
        }
        String name = (String)s.getArgument("screen", String.class);
        ClientVideoScreen screen = area.getScreen(name);
        if (screen == null) {
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u5c4f\u5e55\u672a\u627e\u5230").method_27692(class_124.field_1061));
            return null;
        }
        return screen;
    }

    private boolean checkInvalid(CommandContext<FabricClientCommandSource> s, boolean checkScreen) {
        if (!connected && !VideoPlayerClient.config.alwaysConnected) {
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u672a\u8fde\u63a5\u5230\u670d\u52a1\u5668").method_27692(class_124.field_1061));
            return true;
        }
        if (checkScreen && currentScreen == null) {
            if (isInArea) {
                ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u5f53\u524d\u89c2\u5f71\u533a\u6ca1\u6709\u4e3b\u5c4f\u5e55").method_27692(class_124.field_1061));
            } else {
                ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u5f53\u524d\u6ca1\u6709\u5728\u89c2\u5f71\u533a\u5185").method_27692(class_124.field_1061));
            }
            return true;
        }
        return false;
    }

    private boolean checkInvalidLooking(CommandContext<FabricClientCommandSource> s) {
        if (!connected && !VideoPlayerClient.config.alwaysConnected) {
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u672a\u8fde\u63a5\u5230\u670d\u52a1\u5668").method_27692(class_124.field_1061));
            return true;
        }
        if (currentLooking == null) {
            ((FabricClientCommandSource)s.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u5f53\u524d\u6ca1\u6709\u770b\u5411\u5c4f\u5e55").method_27692(class_124.field_1061));
            return true;
        }
        return false;
    }

    private static void updateBossBar() {
        if (currentLooking != null) {
            class_634 handler = client.method_1562();
            if (!bossBarAdded) {
                handler.method_11078(class_2629.method_34089((class_1259)bossBar));
                bossBarAdded = true;
            }
            ClientVideoScreen screen = currentLooking.getScreen();
            VideoInfo info = (VideoInfo)screen.infos.peek();
            if (info != null && screen.player != null) {
                String time;
                String name = info.name();
                long progress = System.currentTimeMillis() - screen.getStartTime();
                long totalProgress = screen.player.getTotalProgress();
                if (totalProgress > 0L) {
                    boolean showHour = progress >= 3600000L || totalProgress >= 3600000L;
                    time = VideoPlayerClient.formatDuration(progress, showHour) + "/" + VideoPlayerClient.formatDuration(totalProgress, showHour);
                    bossBar.method_5408((float)progress / (float)totalProgress);
                } else {
                    time = VideoPlayerClient.formatDuration(progress, progress >= 3600000L) + "/LIVE";
                    bossBar.method_5408(0.0f);
                }
                bossBar.method_5413(class_2561.method_30163((String)(name + " " + time)));
            } else {
                bossBar.method_5413(class_2561.method_30163((String)"\u65e0"));
                bossBar.method_5408(1.0f);
            }
            handler.method_11078(class_2629.method_34096((class_1259)bossBar));
            handler.method_11078(class_2629.method_34094((class_1259)bossBar));
        } else if (bossBarAdded) {
            class_634 handler = client.method_1562();
            handler.method_11078(class_2629.method_34090((UUID)bossBar.method_5407()));
            bossBarAdded = false;
        }
    }

    private static void checkInteract() {
        class_310 client = VideoPlayerClient.client;
        if (client == null) {
            return;
        }
        isInArea = false;
        currentLooking = null;
        currentScreen = null;
        if (screens.isEmpty()) {
            touchHandler.handle(null);
            return;
        }
        float delta = VideoPlayerClient.client.method_61966().method_60637(true);
        class_243 eyePos = client.field_1724.method_5836(delta);
        class_243 lookVec = client.field_1724.method_5828(delta);
        Vector3f lineStart = new Vector3f((Vector3fc)eyePos.method_46409());
        boolean remoteControl = false;
        for (class_1799 item : client.field_1724.method_5877()) {
            List id;
            class_9280 data;
            if (!class_7923.field_41178.method_10221((Object)item.method_7909()).toString().equals(remoteControlName) || (data = (class_9280)item.method_57353().method_57829(class_9334.field_49637)) == null || (id = data.comp_3354()).isEmpty() || !id.contains(Float.valueOf(remoteControlId))) continue;
            remoteControl = true;
        }
        Vector3f lineEnd = eyePos.method_1019(lookVec.method_1021(remoteControl ? (double)remoteControlRange : (double)noControlRange)).method_46409();
        ArrayList<Intersection.Result> list = new ArrayList<Intersection.Result>();
        for (ClientVideoScreen s2 : screens) {
            ClientVideoScreen screen;
            if (!s2.interactable || (screen = s2.getTrackingScreen()) == null) continue;
            Intersection.Result result = Intersection.intersect(lineStart, lineEnd, screen);
            if (!result.intersects) continue;
            list.add(result);
        }
        Intersection.Result target = list.isEmpty() ? null : Collections.min(list, Comparator.comparing(s -> Float.valueOf(s.distance)));
        currentLooking = target == null || target.screen == null ? null : target.screen;
        touchHandler.handle(target);
        if (currentLooking != null) {
            currentScreen = currentLooking;
            return;
        }
        currentScreen = null;
        block2: for (ClientVideoArea area : areas.values()) {
            if (!area.loaded) continue;
            isInArea = true;
            for (VideoScreen screen : area.screens) {
                ClientVideoScreen s3 = (ClientVideoScreen)screen;
                if (!s3.interactable) continue;
                currentScreen = s3;
                continue block2;
            }
        }
    }

    public static boolean checkVersion(String v) {
        String[] p1 = StringUtils.split((String)v, (char)'.');
        String[] p2 = StringUtils.split((String)VideoPlayerMain.version, (char)'.');
        if (p1.length < 2 || p2.length < 2) {
            return false;
        }
        return p1[0].equals(p2[0]) && p1[1].equals(p2[1]);
    }

    public static void update() {
        if (updated) {
            return;
        }
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("video");
        profiler.method_15396("updateFrame");
        for (ClientVideoScreen screen : screens) {
            if (screen.isPostUpdate()) continue;
            screen.swapTexture();
            screen.updateTexture();
        }
        profiler.method_15405("checkInteract");
        VideoPlayerClient.checkInteract();
        profiler.method_15405("updateBossBar");
        VideoPlayerClient.updateBossBar();
        profiler.method_15407();
        profiler.method_15407();
    }

    public static void postUpdate() {
        if (updated) {
            return;
        }
        updated = true;
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("video");
        profiler.method_15396("updateFrame");
        for (ClientVideoScreen screen : screens) {
            if (!screen.isPostUpdate()) continue;
            screen.updateTexture();
        }
        profiler.method_15407();
        profiler.method_15407();
    }

    private static String formatDuration(long millis, boolean showHour) {
        long all = millis / 1000L;
        long hours = all / 3600L;
        long minutes = all % 3600L / 60L;
        long seconds = all % 60L;
        if (showHour) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    private static void saveConfig() {
        try {
            Files.writeString(configPath, (CharSequence)gson.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadConfig() {
        try {
            config = (Config)gson.fromJson(Files.readString(configPath), Config.class);
        }
        catch (Exception e) {
            config = new Config();
            try {
                VideoPlayerClient.saveConfig();
            }
            catch (Exception e1) {
                e1.addSuppressed(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static Object getEnumValue(String constantName, String ... paths) {
        for (String path : paths) {
            try {
                Class<?> clazz = Class.forName(path);
                if (!clazz.isEnum()) continue;
                Enum enumValue = Enum.valueOf(clazz.asSubclass(Enum.class), constantName);
                return enumValue;
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (IllegalArgumentException e) {
                System.err.println("Enum found, but constant not present: " + constantName);
            }
        }
        throw new RuntimeException("Enum constant not found in any known path: " + constantName);
    }

    static {
        gson = new Gson();
        areas = new HashMap();
        screens = new ArrayList();
        touchHandler = new TouchHandler();
        isInArea = false;
        bossBar = null;
        bossBarAdded = false;
        keyPressed = false;
        connected = false;
        remoteControlName = "minecraft:iron_ingot";
        remoteControlId = -1.0f;
        remoteControlRange = 64.0f;
        noControlRange = 16.0f;
        updated = false;
        disconnectHandler = () -> {};
        SUGGEST_AREAS = (context, builder) -> {
            for (ClientVideoArea a : areas.values()) {
                if (!a.name.startsWith(builder.getRemaining())) continue;
                builder.suggest("\"" + a.name.replace("\\", "\\\\") + "\"");
            }
            return builder.buildFuture();
        };
        SUGGEST_SCREENS = (context, builder) -> {
            ClientVideoArea area = areas.get(context.getArgument("area", String.class));
            if (area == null) {
                return Suggestions.empty();
            }
            for (VideoScreen screen : area.screens) {
                if (!((ClientVideoScreen)screen).interactable || !screen.name.startsWith(builder.getRemaining())) continue;
                builder.suggest("\"" + screen.name.replace("\\", "\\\\") + "\"");
            }
            return builder.buildFuture();
        };
        SUGGEST_REAL_SCREENS = (context, builder) -> {
            ClientVideoArea area = areas.get(context.getArgument("area", String.class));
            if (area == null) {
                return Suggestions.empty();
            }
            for (VideoScreen screen : area.screens) {
                if (!screen.source.isEmpty() || !((ClientVideoScreen)screen).interactable || !screen.name.startsWith(builder.getRemaining())) continue;
                builder.suggest("\"" + screen.name.replace("\\", "\\\\") + "\"");
            }
            return builder.buildFuture();
        };
    }
}

