/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp;

import com.github.squi2rel.vp.DataHolder;
import com.github.squi2rel.vp.network.ServerPacketHandler;
import com.github.squi2rel.vp.network.VideoPayload;
import com.github.squi2rel.vp.provider.VideoProviders;
import com.github.squi2rel.vp.video.StreamListener;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoPlayerMain
implements ModInitializer {
    public static final String MOD_ID = "videoplayer";
    public static final String version = ((ModContainer)FabricLoader.getInstance().getModContainer("videoplayer").orElseThrow()).getMetadata().getVersion().toString();
    public static Throwable error = null;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"videoplayer");

    public void onInitialize() {
        try {
            StreamListener.load();
        }
        catch (Throwable e2) {
            error = e2;
            LOGGER.error("Cannot load vlc library", e2);
            return;
        }
        VideoProviders.register();
        VideoPayload.register();
        ServerLifecycleEvents.SERVER_STARTED.register(DataHolder::load);
        ServerLifecycleEvents.SERVER_STOPPING.register(DataHolder::stop);
        ServerTickEvents.START_WORLD_TICK.register(s -> DataHolder.update());
        ServerPlayConnectionEvents.JOIN.register((e, p, s) -> DataHolder.playerJoin(e.field_14140));
        ServerPlayConnectionEvents.DISCONNECT.register((e, s) -> DataHolder.playerLeave(e.field_14140.method_5667()));
        ServerPlayNetworking.registerGlobalReceiver(VideoPayload.ID, (p, c) -> c.server().execute(() -> {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])p.data());
            try {
                ServerPacketHandler.handle(c.player(), buf);
            }
            catch (Exception e) {
                c.player().field_13987.method_52396(class_2561.method_30163((String)e.toString()));
            }
            finally {
                buf.release();
            }
        }));
        CommandRegistrationCallback.EVENT.register((d, c, e) -> d.register((LiteralArgumentBuilder)class_2170.method_9247((String)"").then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(s -> {
            if (!((class_2168)s.getSource()).method_43737()) {
                return 0;
            }
            ServerPacketHandler.sendTo(((class_2168)s.getSource()).method_44023(), ServerPacketHandler.execute((String)s.getArgument("command", String.class)));
            return 1;
        }))));
    }
}

