/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.network;

import com.github.squi2rel.vp.DataHolder;
import com.github.squi2rel.vp.ServerConfig;
import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.network.ByteBufUtils;
import com.github.squi2rel.vp.network.PacketID;
import com.github.squi2rel.vp.network.VideoPayload;
import com.github.squi2rel.vp.provider.PlayerProviderSource;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.provider.VideoProviders;
import com.github.squi2rel.vp.video.VideoArea;
import com.github.squi2rel.vp.video.VideoScreen;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8710;

public class ServerPacketHandler {
    public static void handle(class_3222 player, ByteBuf buf) {
        short type = buf.readUnsignedByte();
        VideoPlayerMain.LOGGER.info("server type: {}", (Object)type);
        switch (type) {
            case 0: {
                ByteBufUtils.readString(buf, 16);
                DataHolder.lock();
                DataHolder.allPlayers.add(player.method_5667());
                DataHolder.unlock();
                break;
            }
            case 1: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                String url = ByteBufUtils.readString(buf, 256);
                if (!ServerPacketHandler.fetchSource(player, url, screen::addInfo)) break;
                return;
            }
            case 2: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null || screen.currentPlaying() == null) {
                    return;
                }
                ServerPacketHandler.sendTo(player, ServerPacketHandler.sync(screen, screen.getProgress()));
                break;
            }
            case 3: {
                VideoArea area = VideoArea.from(ByteBufUtils.readVec3(buf), ByteBufUtils.readVec3(buf), ServerPacketHandler.readName(buf), player.method_37908().method_27983().method_29177().toString());
                area.initServer();
                DataHolder.lock();
                DataHolder.areas.computeIfAbsent(area.dim, k -> new HashMap()).put(area.name, area);
                DataHolder.unlock();
                break;
            }
            case 4: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                DataHolder.lock();
                DataHolder.areas.get(area.dim).remove(area.name).remove();
                if (area.hasPlayer()) {
                    byte[] data = ServerPacketHandler.removeArea(area);
                    class_3324 pm = Objects.requireNonNull(player.method_5682()).method_3760();
                    area.forEachPlayer(p -> ServerPacketHandler.sendTo(pm.method_14602(p), data));
                }
                DataHolder.unlock();
                break;
            }
            case 5: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = VideoScreen.read(buf, area);
                screen.initServer();
                DataHolder.lock();
                area.addScreen(screen);
                if (area.hasPlayer()) {
                    byte[] data = ServerPacketHandler.createScreen(List.of(screen));
                    class_3324 pm = Objects.requireNonNull(player.method_5682()).method_3760();
                    area.forEachPlayer(p -> ServerPacketHandler.sendTo(pm.method_14602(p), data));
                }
                DataHolder.unlock();
                break;
            }
            case 6: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                DataHolder.lock();
                VideoScreen removed = area.removeScreen(ServerPacketHandler.readName(buf));
                if (removed != null && area.hasPlayer()) {
                    byte[] data = ServerPacketHandler.removeScreen(removed);
                    class_3324 pm = Objects.requireNonNull(player.method_5682()).method_3760();
                    area.forEachPlayer(p -> ServerPacketHandler.sendTo(pm.method_14602(p), data));
                }
                DataHolder.unlock();
                break;
            }
            case 10: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                boolean force = buf.readBoolean();
                if (force) {
                    screen.skip();
                    return;
                }
                screen.voteSkip(player.method_5667());
                break;
            }
            case 11: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                screen.setSkipPercent(buf.readFloat());
                break;
            }
            case 13: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                ByteBufUtils.readString(buf, 1024);
                break;
            }
            case 14: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                ServerPacketHandler.readUV(buf, screen);
                if (!area.hasPlayer()) break;
                byte[] data = ServerPacketHandler.slice(screen, screen.u1, screen.v1, screen.u2, screen.v2);
                class_3324 pm = Objects.requireNonNull(player.method_5682()).method_3760();
                area.forEachPlayer(p -> ServerPacketHandler.sendTo(pm.method_14602(p), data));
                break;
            }
            case 15: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen != null) break;
                return;
            }
            case 16: {
                short id = buf.readUnsignedByte();
                if (id > PacketID.Action.VALUES.length) {
                    player.field_13987.method_52396(class_2561.method_30163((String)("Unknown action type: " + id)));
                    return;
                }
                PacketID.Action action = PacketID.Action.VALUES[id];
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                int value = buf.readInt();
                if (!action.verify(value)) {
                    player.field_13987.method_52396(class_2561.method_30163((String)("Invalid value: " + value)));
                    return;
                }
                action.apply(screen, value);
                if (!area.hasPlayer()) break;
                byte[] data = ServerPacketHandler.setMeta(screen, id, value);
                class_3324 pm = Objects.requireNonNull(player.method_5682()).method_3760();
                area.forEachPlayer(p -> ServerPacketHandler.sendTo(pm.method_14602(p), data));
                break;
            }
            case 17: {
                VideoArea area = ServerPacketHandler.getArea(player, ServerPacketHandler.readName(buf));
                if (area == null) {
                    return;
                }
                VideoScreen screen = area.getScreen(ServerPacketHandler.readName(buf));
                if (screen == null) {
                    return;
                }
                String key = ServerPacketHandler.readName(buf);
                int value = buf.readInt();
                boolean remove = buf.readBoolean();
                if (remove) {
                    screen.meta.remove(key);
                } else {
                    screen.meta.put(key, value);
                }
                if (!area.hasPlayer()) break;
                byte[] data = ServerPacketHandler.setCustomMeta(screen, key, value, remove);
                class_3324 pm = Objects.requireNonNull(player.method_5682()).method_3760();
                area.forEachPlayer(p -> ServerPacketHandler.sendTo(pm.method_14602(p), data));
                break;
            }
            default: {
                player.field_13987.method_52396(class_2561.method_30163((String)("Unknown packet type: " + type)));
            }
        }
        if (buf.readableBytes() > 0) {
            player.field_13987.method_52396(class_2561.method_30163((String)("Illegal packet! Remaining: " + buf.readableBytes())));
        }
    }

    private static boolean fetchSource(class_3222 player, String url, Consumer<VideoInfo> cb) {
        CompletableFuture<VideoInfo> video = VideoProviders.from(url, new PlayerProviderSource(player));
        if (video == null) {
            player.method_64398(class_2561.method_30163((String)"\u65e0\u6cd5\u89e3\u6790\u89c6\u9891\u6e90"));
            return true;
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                VideoPlayerMain.LOGGER.info("start fetch");
                return (VideoInfo)video.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).thenAccept(v -> {
            try {
                if (v == null) {
                    player.method_64398(class_2561.method_30163((String)"\u65e0\u6cd5\u89e3\u6790\u89c6\u9891\u6e90"));
                    return;
                }
                cb.accept((VideoInfo)v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return false;
    }

    private static VideoArea getArea(class_3222 player, String name) {
        String dim = player.method_51469().method_27983().method_29177().toString();
        DataHolder.lock();
        VideoArea area = DataHolder.areas.get(dim).get(name);
        DataHolder.unlock();
        return area != null && area.containsPlayer(player.method_5667()) ? area : null;
    }

    private static String readName(ByteBuf buf) {
        return ByteBufUtils.readString(buf, 32);
    }

    private static ByteBuf create(int id) {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer();
        buf.writeByte((int)((byte)id));
        return buf;
    }

    private static byte[] toByteArray(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        buf.release();
        return bytes;
    }

    public static void readUV(ByteBuf buf, VideoScreen screen) {
        screen.u1 = buf.readFloat();
        screen.v1 = buf.readFloat();
        screen.u2 = buf.readFloat();
        screen.v2 = buf.readFloat();
    }

    public static void writeUV(ByteBuf buf, VideoScreen screen) {
        buf.writeFloat(screen.u1);
        buf.writeFloat(screen.v1);
        buf.writeFloat(screen.u2);
        buf.writeFloat(screen.v2);
    }

    public static void sendTo(class_3222 player, byte[] bytes) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new VideoPayload(bytes));
    }

    public static byte[] config(String version, ServerConfig config) {
        ByteBuf buf = ServerPacketHandler.create(0);
        ByteBufUtils.writeString(buf, version);
        ByteBufUtils.writeString(buf, config.remoteControlName);
        buf.writeFloat(config.remoteControlId);
        buf.writeFloat(config.remoteControlRange);
        buf.writeFloat(config.noControlRange);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] request(VideoScreen screen, VideoInfo info) {
        ByteBuf buf = ServerPacketHandler.create(1);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        VideoInfo.write(buf, info);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] sync(VideoScreen screen, long time) {
        ByteBuf buf = ServerPacketHandler.create(2);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        buf.writeLong(time);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] createArea(VideoArea area) {
        ByteBuf buf = ServerPacketHandler.create(3);
        ByteBufUtils.writeString(buf, area.name);
        VideoArea.write(buf, area);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] removeArea(VideoArea area) {
        ByteBuf buf = ServerPacketHandler.create(4);
        ByteBufUtils.writeString(buf, area.name);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] createScreen(List<VideoScreen> screens) {
        ByteBuf buf = ServerPacketHandler.create(5);
        ByteBufUtils.writeString(buf, screens.getFirst().area.name);
        buf.writeByte(screens.size());
        for (VideoScreen screen : screens) {
            VideoScreen.write(buf, screen);
            ServerPacketHandler.writeUV(buf, screen);
            screen.writeMeta(buf);
        }
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] removeScreen(VideoScreen screen) {
        ByteBuf buf = ServerPacketHandler.create(6);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] loadArea(VideoArea area) {
        ByteBuf buf = ServerPacketHandler.create(7);
        ByteBufUtils.writeString(buf, area.name);
        for (VideoScreen screen : area.screens) {
            VideoInfo info = screen.currentPlaying();
            if (info == null) continue;
            ByteBufUtils.writeString(buf, screen.name);
            VideoInfo.write(buf, info);
            buf.writeLong(screen.getProgress());
        }
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] unloadArea(VideoArea area) {
        ByteBuf buf = ServerPacketHandler.create(8);
        ByteBufUtils.writeString(buf, area.name);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] updatePlaylist(List<VideoScreen> screens) {
        ByteBuf buf = ServerPacketHandler.create(9);
        ByteBufUtils.writeString(buf, screens.getFirst().area.name);
        buf.writeByte(screens.size());
        for (VideoScreen screen : screens) {
            ByteBufUtils.writeString(buf, screen.name);
            buf.writeByte(screen.infos.size());
            for (VideoInfo info : screen.infos) {
                ByteBufUtils.writeString(buf, info.playerName());
                ByteBufUtils.writeString(buf, info.name());
            }
        }
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] skip(VideoScreen screen) {
        ByteBuf buf = ServerPacketHandler.create(10);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] execute(String command) {
        ByteBuf buf = ServerPacketHandler.create(12);
        ByteBufUtils.writeString(buf, command);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] slice(VideoScreen screen, float u1, float v1, float u2, float v2) {
        ByteBuf buf = ServerPacketHandler.create(14);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        buf.writeFloat(u1);
        buf.writeFloat(v1);
        buf.writeFloat(u2);
        buf.writeFloat(v2);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] setMeta(VideoScreen screen, int actionId, int value) {
        ByteBuf buf = ServerPacketHandler.create(16);
        buf.writeByte(actionId);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        buf.writeInt(value);
        return ServerPacketHandler.toByteArray(buf);
    }

    public static byte[] setCustomMeta(VideoScreen screen, String key, int value, boolean remove) {
        ByteBuf buf = ServerPacketHandler.create(17);
        ByteBufUtils.writeString(buf, screen.area.name);
        ByteBufUtils.writeString(buf, screen.name);
        ByteBufUtils.writeString(buf, key);
        buf.writeInt(value);
        buf.writeBoolean(remove);
        return ServerPacketHandler.toByteArray(buf);
    }
}

