/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.provider;

import com.github.squi2rel.vp.provider.IProviderSource;
import com.github.squi2rel.vp.provider.IVideoProvider;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.video.StreamListener;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class NetworkProvider
implements IVideoProvider {
    @Override
    @Nullable
    public CompletableFuture<VideoInfo> from(String str, IProviderSource source) {
        char first = str.charAt(0);
        if (first == '/' || first == '\\' || first == '.' || str.charAt(1) == ':') {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> {
            source.reply("\u6b63\u5728\u89e3\u6790\u89c6\u9891\u6d41");
            StreamInfo info = NetworkProvider.getStreamInfo(str);
            if (info == null) {
                source.reply("\u89e3\u6790\u89c6\u9891\u6d41\u5931\u8d25");
                return null;
            }
            return new VideoInfo(source.name(), info.name, str, "", -1L, info.seekable, NO_PARAMS);
        });
    }

    @Nullable
    private static StreamInfo getStreamInfo(String mrl) {
        boolean seekable;
        StreamListener listener = new StreamListener(new VideoInfo(null, null, mrl, null, -1L, false, NO_PARAMS));
        CompletableFuture lock = new CompletableFuture();
        listener.timeout(() -> lock.complete(null));
        listener.errored(() -> lock.complete(null));
        listener.playing(lock::complete);
        listener.listen();
        try {
            Boolean b = (Boolean)lock.get();
            if (b == null) {
                return null;
            }
            seekable = b;
        }
        catch (Exception e) {
            return null;
        }
        listener.cancel();
        return new StreamInfo(NetworkProvider.getName(mrl), seekable);
    }

    private static String getName(String mrl) {
        String path = mrl.toLowerCase();
        String name = "Unknown Stream";
        if (path.startsWith("http") && path.contains(".m3u8")) {
            name = "HLS Stream";
        } else if (path.startsWith("rtsp://") || path.startsWith("rtspt://")) {
            name = "RTSP Stream";
        } else if (path.startsWith("http")) {
            name = "HTTP Stream";
        } else if (path.startsWith("rtp://")) {
            name = "RTP Stream";
        } else if (path.startsWith("mms://")) {
            name = "MMS Stream";
        }
        return name;
    }

    private record StreamInfo(String name, boolean seekable) {
    }
}

