/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.provider;

import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.provider.EntityViewProvider;
import com.github.squi2rel.vp.provider.IProviderSource;
import com.github.squi2rel.vp.provider.IVideoProvider;
import com.github.squi2rel.vp.provider.NetworkProvider;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.provider.bilibili.BiliBiliLiveProvider;
import com.github.squi2rel.vp.provider.bilibili.BiliBiliVideoProvider;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class VideoProviders {
    public static ArrayList<IVideoProvider> providers = new ArrayList();

    public static void register() {
        providers.add(new BiliBiliVideoProvider());
        providers.add(new BiliBiliLiveProvider());
        providers.add(new EntityViewProvider());
        providers.add(new NetworkProvider());
    }

    @Nullable
    public static CompletableFuture<VideoInfo> from(String str, IProviderSource source) {
        VideoPlayerMain.LOGGER.info("Player {} requested {}", (Object)source.name(), (Object)str);
        try {
            for (IVideoProvider provider : providers) {
                CompletableFuture<VideoInfo> info = provider.from(str, source);
                if (info == null) continue;
                VideoPlayerMain.LOGGER.info("Using {}", (Object)provider.getClass().getSimpleName());
                return info;
            }
            VideoPlayerMain.LOGGER.info("No suitable provider");
        }
        catch (Exception e) {
            VideoPlayerMain.LOGGER.error(e.toString());
            source.reply(e.toString());
        }
        return null;
    }
}

