/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.provider.bilibili;

import com.github.squi2rel.vp.provider.IProviderSource;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.provider.bilibili.BiliBiliProvider;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class BiliBiliLiveProvider
extends BiliBiliProvider {
    public static final String FETCH_URL = "https://api.live.bilibili.com/room/v1/Room/get_info?room_id=%s";
    public static final String PLAY_URL = "https://api.live.bilibili.com/room/v1/Room/playUrl?cid=%s&platform=web&qn=10000";
    public static final Pattern REGEX = Pattern.compile("(?<=https://live\\.bilibili\\.com/)\\d+");

    @Override
    @Nullable
    public CompletableFuture<VideoInfo> from(String str, IProviderSource source) {
        Matcher matcher = REGEX.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String cid = matcher.group();
        return CompletableFuture.supplyAsync(() -> {
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpResponse<String> response = client.send(BiliBiliLiveProvider.makeRequest(String.format(FETCH_URL, cid)), HttpResponse.BodyHandlers.ofString());
                JsonObject root = JsonParser.parseString((String)response.body()).getAsJsonObject().getAsJsonObject("data");
                if (root.get("live_status").getAsLong() != 1L) {
                    source.reply("\u76f4\u64ad\u95f4\u672a\u5f00\u64ad");
                    BiliBiliProvider.VideoMeta videoMeta = null;
                    return videoMeta;
                }
                BiliBiliProvider.VideoMeta videoMeta = new BiliBiliProvider.VideoMeta(root.get("title").getAsString(), root.get("room_id").getAsString());
                return videoMeta;
            }
            catch (Exception e) {
                source.reply(e.toString());
                return null;
            }
        }).thenApply(meta -> {
            if (meta == null) {
                return null;
            }
            HttpClient client = HttpClient.newHttpClient();
            try {
                HttpResponse<String> response = client.send(BiliBiliLiveProvider.makeRequest(String.format(PLAY_URL, meta.cid())), HttpResponse.BodyHandlers.ofString());
                JsonObject root = JsonParser.parseString((String)response.body()).getAsJsonObject().getAsJsonObject("data");
                String url = root.getAsJsonArray("durl").get(0).getAsJsonObject().get("url").getAsString();
                VideoInfo videoInfo = new VideoInfo(source.name(), meta.title(), url, str, System.currentTimeMillis() + 10000L, false, VLC_PARAMS);
                if (client != null) {
                    client.close();
                }
                return videoInfo;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    source.reply(e.toString());
                    return null;
                }
            }
        });
    }
}

