/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.provider.bilibili;

import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.provider.IVideoProvider;
import com.github.squi2rel.vp.provider.bilibili.BiliTicket;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.concurrent.CompletableFuture;

public abstract class BiliBiliProvider
implements IVideoProvider {
    public static final String UA = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36 Edg/136.0.0.0";
    public static final String[] VLC_PARAMS = new String[]{":http-user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36 Edg/136.0.0.0", ":http-referrer=https://www.bilibili.com"};
    public static String biliTicket;
    public static long expireTime;

    protected static HttpRequest makeRequest(String url) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", UA).header("Referer", "https://www.bilibili.com");
        if (biliTicket != null && System.currentTimeMillis() < expireTime) {
            builder.header("Cookie", "bili_ticket=" + biliTicket);
        } else if (System.currentTimeMillis() > expireTime) {
            CompletableFuture.runAsync(() -> {
                try {
                    biliTicket = JsonParser.parseString((String)BiliTicket.getBiliTicket("")).getAsJsonObject().getAsJsonObject("data").get("ticket").getAsString();
                    VideoPlayerMain.LOGGER.info("bilibili ticket: {}", (Object)biliTicket);
                    expireTime = System.currentTimeMillis() + 259260000L;
                }
                catch (Exception ignored) {
                    expireTime = System.currentTimeMillis() + 600000L;
                }
            });
        }
        return builder.build();
    }

    protected record VideoMeta(String title, String cid) {
    }
}

